/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.representation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Organization {
    @Valid
    private String id = null;
    @Valid
    private String name = null;
    @Valid
    private String displayName = null;
    @Valid
    private String url = null;
    @Valid
    private String realm = null;
    @Valid
    private Set<String> domains = Sets.newHashSet();
    @Valid
    private Map<String, List<String>> attributes = Maps.newHashMap();

    public Organization id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Organization name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Organization displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Organization domains(Set<String> domains) {
        this.domains = domains;
        return this;
    }

    @JsonProperty(value="domains")
    public Set<String> getDomains() {
        return this.domains;
    }

    public void setDomains(Set<String> domains) {
        this.domains = domains;
    }

    public Organization url(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Organization realm(String realm) {
        this.realm = realm;
        return this;
    }

    @JsonProperty(value="realm")
    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Organization attribute(String name, String value) {
        ArrayList list = this.attributes.get(name);
        if (list == null) {
            list = Lists.newArrayList();
        }
        if (!list.contains(value)) {
            list.add(value);
        }
        this.attributes.put(name, list);
        return this;
    }

    @JsonProperty(value="attributes")
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization organization = (Organization)o;
        return Objects.equals(this.id, organization.id) && Objects.equals(this.name, organization.name) && Objects.equals(this.displayName, organization.displayName) && Objects.equals(this.domains, organization.domains) && Objects.equals(this.url, organization.url) && Objects.equals(this.realm, organization.realm) && Objects.equals(this.attributes, organization.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.displayName, this.domains, this.url, this.realm, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organization {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    realm: ").append(this.toIndentedString(this.realm)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

