/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.representation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Team {
    @Valid
    private String id = null;
    @Valid
    private String name = null;
    @Valid
    private String organizationId = null;
    @Valid
    private Map<String, List<String>> attributes = Maps.newHashMap();

    public Team id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Team name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Team organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @JsonProperty(value="organizationId")
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public Team attribute(String name, String value) {
        ArrayList list = this.attributes.get(name);
        if (list == null) {
            list = Lists.newArrayList();
        }
        if (!list.contains(value)) {
            list.add(value);
        }
        this.attributes.put(name, list);
        return this;
    }

    @JsonProperty(value="attributes")
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Team team = (Team)o;
        return Objects.equals(this.id, team.id) && Objects.equals(this.name, team.name) && Objects.equals(this.organizationId, team.organizationId) && Objects.equals(this.attributes, team.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.organizationId, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Team {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

