/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import io.phasetwo.service.resource.Cors;
import io.phasetwo.service.resource.CorsResource;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.ClientConnection;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.Permissions;

public abstract class AbstractAdminResource<T extends AdminAuth> {
    private static final Logger log = Logger.getLogger(AbstractAdminResource.class);
    protected final ClientConnection connection;
    protected final HttpHeaders headers;
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected T auth;
    protected AdminPermissionEvaluator permissions;
    protected AdminEventBuilder adminEvent;
    protected UserModel user;
    protected RealmModel adminRealm;

    protected AbstractAdminResource(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.headers = session.getContext().getRequestHeaders();
        this.connection = session.getContext().getConnection();
    }

    protected AbstractAdminResource(AbstractAdminResource<T> parent) {
        this.connection = parent.connection;
        this.headers = parent.headers;
        this.session = parent.session;
        this.realm = parent.realm;
        this.auth = parent.auth;
        this.permissions = parent.permissions;
        this.adminEvent = parent.adminEvent;
        this.user = parent.user;
        this.adminRealm = parent.adminRealm;
    }

    public final void setup() {
        this.setupAuth();
        this.setupEvents();
        this.setupPermissions();
        this.setupCors();
    }

    private void setupCors() {
        HttpRequest request = this.session.getContext().getHttpRequest();
        HttpResponse response = this.session.getContext().getHttpResponse();
        Cors.add(request).allowedOrigins(this.auth.getToken()).allowedMethods(CorsResource.METHODS).exposedHeaders("Location").auth().build(response);
    }

    private void setupAuth() {
        ClientModel client;
        AccessToken token;
        AppAuthManager authManager = new AppAuthManager();
        String tokenString = AppAuthManager.extractAuthorizationHeaderToken((HttpHeaders)this.headers);
        if (tokenString == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        try {
            JWSInput input = new JWSInput(tokenString);
            token = (AccessToken)input.readJsonContent(AccessToken.class);
        }
        catch (JWSInputException e) {
            throw new NotAuthorizedException((Object)"Bearer token format error", new Object[0]);
        }
        String realmName = token.getIssuer().substring(token.getIssuer().lastIndexOf(47) + 1);
        RealmManager realmManager = new RealmManager(this.session);
        this.adminRealm = realmManager.getRealmByName(realmName);
        if (this.adminRealm == null) {
            throw new NotAuthorizedException((Object)"Unknown realm in token", new Object[0]);
        }
        log.debugf("Realm from resource provider is %s. Realm from token is %s", (Object)this.realm.getName(), (Object)this.adminRealm.getName());
        this.session.getContext().setRealm(this.adminRealm);
        AuthenticationManager.AuthResult authResult = this.authenticateBearerToken(tokenString, this.session, this.adminRealm, (UriInfo)this.session.getContext().getUri(), this.connection, this.headers);
        if (authResult == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        this.session.getContext().setRealm(this.realm);
        ClientModel clientModel = client = this.adminRealm.getName().equals(Config.getAdminRealm()) ? this.realm.getMasterAdminClient() : this.realm.getClientByClientId(realmManager.getRealmAdminClientId(this.realm));
        if (client == null) {
            throw new NotFoundException("Could not find client for authorization");
        }
        this.user = authResult.getUser();
        Type genericSuperClass = this.getClass().getGenericSuperclass();
        ParameterizedType parametrizedType = null;
        while (parametrizedType == null) {
            if (genericSuperClass instanceof ParameterizedType) {
                parametrizedType = (ParameterizedType)genericSuperClass;
                continue;
            }
            genericSuperClass = ((Class)genericSuperClass).getGenericSuperclass();
        }
        Class clazz = (Class)parametrizedType.getActualTypeArguments()[0];
        try {
            Constructor constructor = clazz.getConstructor(RealmModel.class, AccessToken.class, UserModel.class, ClientModel.class);
            this.auth = (AdminAuth)constructor.newInstance(this.realm, token, this.user, client);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            log.error((Object)"Failed to instantiate AdminAuth instance", (Throwable)ex);
        }
    }

    private void setupEvents() {
        this.adminEvent = new AdminEventBuilder(this.realm, this.auth, this.session, this.session.getContext().getConnection()).realm(this.realm);
    }

    private void setupPermissions() {
        this.permissions = Permissions.evaluator(this.session, this.realm, this.adminRealm, this.user);
    }

    private AuthenticationManager.AuthResult authenticateBearerToken(String tokenString, KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        return new AppAuthManager.BearerTokenAuthenticator(session).setRealm(realm).setUriInfo(uriInfo).setTokenString(tokenString).setConnection(connection).setHeaders(headers).authenticate();
    }
}

