/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.model.jpa.entity.InvitationEntity;
import io.phasetwo.service.representation.Invitation;
import io.phasetwo.service.representation.Organization;
import io.phasetwo.service.representation.OrganizationRole;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.representations.account.UserRepresentation;

public class Converters {
    public static OrganizationRole convertOrganizationRole(OrganizationRoleModel m) {
        OrganizationRole r = new OrganizationRole().id(m.getId()).name(m.getName()).description(m.getDescription());
        return r;
    }

    public static Organization convertOrganizationModelToOrganization(OrganizationModel e) {
        Organization o = new Organization().id(e.getId()).name(e.getName()).displayName(e.getDisplayName()).domains(e.getDomains()).url(e.getUrl()).realm(e.getRealm().getName());
        o.setAttributes(e.getAttributes());
        return o;
    }

    public static UserRepresentation convertUserEntityToUserRepresentation(UserEntity e) {
        UserRepresentation r = new UserRepresentation();
        r.setEmail(e.getEmail());
        r.setFirstName(e.getFirstName());
        r.setLastName(e.getLastName());
        r.setUsername(e.getUsername());
        r.setEmailVerified(Boolean.valueOf(e.isEmailVerified()));
        r.setId(e.getId());
        HashMap attr = Maps.newHashMap();
        e.getAttributes().forEach(a -> {
            List l = (List)attr.get(a.getName());
            if (l == null) {
                l = Lists.newArrayList();
            }
            if (!l.contains(a.getValue())) {
                l.add(a.getValue());
            }
            attr.put(a.getName(), l);
        });
        r.setAttributes((Map)attr);
        return r;
    }

    public static Invitation convertInvitationEntityToInvitation(InvitationEntity e) {
        Invitation i = new Invitation().id(e.getId()).email(e.getEmail()).createdAt(e.getCreatedAt()).inviterId(e.getInviterId()).organizationId(e.getOrganization().getId()).roles(Lists.newArrayList(e.getRoles()));
        HashMap attr = Maps.newHashMap();
        e.getAttributes().forEach(a -> {
            List l = (List)attr.get(a.getName());
            if (l == null) {
                l = Lists.newArrayList();
            }
            if (!l.contains(a.getValue())) {
                l.add(a.getValue());
            }
            attr.put(a.getName(), l);
        });
        i.setAttributes(attr);
        return i;
    }

    public static Invitation convertInvitationModelToInvitation(InvitationModel e) {
        Invitation i = new Invitation().id(e.getId()).email(e.getEmail()).createdAt(e.getCreatedAt()).inviterId(e.getInviter().getId()).invitationUrl(e.getUrl()).organizationId(e.getOrganization().getId()).roles(Lists.newArrayList(e.getRoles()));
        i.setAttributes(Maps.newHashMap(e.getAttributes()));
        return i;
    }
}

