/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import io.phasetwo.service.resource.Cors;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;

public class CorsResource {
    private static final Logger log = Logger.getLogger(CorsResource.class);
    private final KeycloakSession session;
    private final HttpRequest request;
    public static final String[] METHODS = new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"};

    public CorsResource(KeycloakSession session, HttpRequest request) {
        this.session = session;
        this.request = request;
    }

    @OPTIONS
    @Path(value="{any:.*}")
    public Response preflight() {
        log.debug((Object)"CORS OPTIONS preflight request");
        return Cors.add(this.request, Response.ok()).auth().allowedMethods(METHODS).preflight().build();
    }
}

