/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.common.base.Joiner;
import com.google.common.hash.Hashing;
import io.phasetwo.service.model.DomainModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.representation.Domain;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.resource.OrganizationResourceType;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.events.admin.OperationType;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;

public class DomainsResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(DomainsResource.class);
    private final OrganizationModel organization;
    private static final String RECORD_KEY = "_org-domain-ownership";

    public DomainsResource(OrganizationAdminResource parent, OrganizationModel organization) {
        super(parent);
        this.organization = organization;
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public Stream<Domain> getDomains() {
        log.debugf("Get domains for %s %s", (Object)this.realm.getName(), (Object)this.organization.getId());
        return this.organization.getDomains().stream().map(s -> this.lookupDomain((String)s)).map(d -> this.fromModel((DomainModel)d));
    }

    @GET
    @Path(value="{domainName}")
    @Produces(value={"application/json"})
    public Domain getDomain(@PathParam(value="domainName") String domainName) {
        log.debugf("Get domain for %s %s %s", (Object)domainName, (Object)this.realm.getName(), (Object)this.organization.getId());
        return this.fromModel(this.lookupDomain(domainName));
    }

    private Domain fromModel(DomainModel d) {
        return new Domain().domainName(d.getDomain()).verified(d.isVerified()).recordKey(RECORD_KEY).recordValue(this.getRecordValue(d.getDomain()));
    }

    private String getRecordKey(String domainName) {
        return String.format("%s.%s", RECORD_KEY, domainName);
    }

    private String getRecordValue(String domainName) {
        return Hashing.sha256().hashString((CharSequence)String.format("%s %s", domainName, this.organization.getId()), StandardCharsets.UTF_8).toString();
    }

    private DomainModel lookupDomain(String domainName) {
        DomainModel d = this.organization.getDomain(domainName);
        if (d == null) {
            throw new NotFoundException(String.format("%s not a domain in %s", domainName, this.organization.getId()));
        }
        return d;
    }

    private void startVerification(String domainName) {
        block3: {
            String valueToCompare = this.getRecordValue(domainName);
            try {
                Lookup lookup = new Lookup(this.getRecordKey(domainName), 16);
                lookup.setResolver((Resolver)new SimpleResolver());
                lookup.setCache(null);
                Record[] records = lookup.run();
                if (lookup.getResult() != 0) break block3;
                StringBuilder builder = new StringBuilder();
                for (Record record : records) {
                    TXTRecord txt = (TXTRecord)record;
                    builder.delete(0, builder.length());
                    String text = Joiner.on((String)"").join(txt.getStrings().iterator());
                    log.infof("found record for %s = %s", (Object)this.getRecordKey(domainName), (Object)text);
                    if (!valueToCompare.equals(text)) continue;
                    log.infof("verified domain %s using %s", (Object)domainName, (Object)valueToCompare);
                    this.lookupDomain(domainName).setVerified(true);
                    break;
                }
            }
            catch (Exception e) {
                log.warn((Object)"Error during DNS verification", (Throwable)e);
            }
        }
    }

    @POST
    @Path(value="{domainName}/verify")
    @Produces(value={"application/json"})
    public Response verifyDomain(@PathParam(value="domainName") String domainName) {
        log.infof("verifyDomain %s %s", (Object)domainName, (Object)this.organization.getId());
        if (((OrganizationAdminAuth)this.auth).hasManageOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgManageOrg(this.organization)) {
            log.infof("startVerification %s %s", (Object)domainName, (Object)this.organization.getId());
            this.startVerification(this.lookupDomain(domainName).getDomain());
            DomainModel d = this.lookupDomain(domainName);
            Domain domain = this.fromModel(d);
            log.infof("endVerification %s %s %s", (Object)domainName, (Object)this.organization.getId(), (Object)domain);
            this.adminEvent.resource(OrganizationResourceType.DOMAIN.name()).operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation((Object)domainName).success();
            return Response.accepted().entity((Object)domain).build();
        }
        throw new NotAuthorizedException((Object)String.format("Insufficient permission to validate domains for %s", this.organization.getId()), new Object[0]);
    }
}

