/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.util.IdentityProviders;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;

public class IdentityProviderResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(IdentityProviderResource.class);
    private final OrganizationModel organization;
    private final String alias;
    private final org.keycloak.services.resources.admin.IdentityProviderResource kcResource;

    public IdentityProviderResource(OrganizationAdminResource parent, OrganizationModel organization, String alias, org.keycloak.services.resources.admin.IdentityProviderResource kcResource) {
        super(parent);
        this.organization = organization;
        this.alias = alias;
        this.kcResource = kcResource;
    }

    @GET
    @Produces(value={"application/json"})
    public IdentityProviderRepresentation getIdentityProvider() {
        return this.kcResource.getIdentityProvider();
    }

    @DELETE
    public Response delete() {
        this.requireManage();
        return this.kcResource.delete();
    }

    @POST
    @Path(value="unlink")
    public Response unlinkIdp() {
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs()) {
            throw new NotAuthorizedException((Object)String.format("Insufficient permission to unlink identity provider for %s", this.organization.getId()), new Object[0]);
        }
        IdentityProviderModel idp = this.realm.getIdentityProviderByAlias(this.alias);
        if (idp == null) {
            throw new NotFoundException(String.format("No IdP found with alias %s", this.alias));
        }
        IdentityProviders.removeOrganization(this.organization.getId(), idp);
        this.realm.updateIdentityProvider(idp);
        return Response.noContent().build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(IdentityProviderRepresentation providerRep) {
        this.requireManage();
        IdentityProviderModel idp = this.realm.getIdentityProviderByAlias(this.alias);
        if (idp == null) {
            throw new NotFoundException(String.format("No IdP found with alias %s", this.alias));
        }
        Set<String> orgs = IdentityProviders.getAttributeMultivalued(idp.getConfig(), "home.idp.discovery.org");
        providerRep.getConfig().put("hideOnLoginPage", "true");
        IdentityProviders.setAttributeMultivalued(providerRep.getConfig(), "home.idp.discovery.org", orgs);
        providerRep.getConfig().put("home.idp.discovery.shared", (String)idp.getConfig().get("home.idp.discovery.shared"));
        providerRep.setAlias(this.alias);
        return this.kcResource.update(providerRep);
    }

    @GET
    @Path(value="mappers")
    @Produces(value={"application/json"})
    public Stream<IdentityProviderMapperRepresentation> getMappers() {
        return this.kcResource.getMappers();
    }

    @POST
    @Path(value="mappers")
    @Consumes(value={"application/json"})
    public Response addMapper(IdentityProviderMapperRepresentation mapper) {
        this.requireManage();
        return this.kcResource.addMapper(mapper);
    }

    @GET
    @Path(value="mappers/{id}")
    @Produces(value={"application/json"})
    public IdentityProviderMapperRepresentation getMapperById(@PathParam(value="id") String id) {
        return this.kcResource.getMapperById(id);
    }

    @PUT
    @Path(value="mappers/{id}")
    @Consumes(value={"application/json"})
    public void update(@PathParam(value="id") String id, IdentityProviderMapperRepresentation rep) {
        this.requireManage();
        this.kcResource.update(id, rep);
    }

    @DELETE
    @Path(value="mappers/{id}")
    public void delete(@PathParam(value="id") String id) {
        this.requireManage();
        this.kcResource.delete(id);
    }

    private void requireManage() {
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs() && !((OrganizationAdminAuth)this.auth).hasOrgManageIdentityProviders(this.organization)) {
            throw new NotAuthorizedException((Object)String.format("Insufficient permission to manage identity providers for %s", this.organization.getId()), new Object[0]);
        }
    }
}

