/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.common.base.Strings;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.representation.LinkIdp;
import io.phasetwo.service.resource.IdentityProviderResource;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminPermissionEvaluator;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.util.IdentityProviders;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.services.managers.LDAPServerCapabilitiesManager;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class IdentityProvidersResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(IdentityProvidersResource.class);
    private final OrganizationModel organization;

    public IdentityProvidersResource(OrganizationAdminResource parent, OrganizationModel organization) {
        super(parent);
        this.organization = organization;
    }

    @Path(value="{alias}")
    public IdentityProviderResource identityProvider(@PathParam(value="alias") String alias) {
        org.keycloak.services.resources.admin.IdentityProviderResource kcResource = this.getIdpResource().getIdentityProvider(alias);
        if (!this.canManageIdp()) {
            throw new NotAuthorizedException((Object)String.format("Insufficient permission to manage identity provider %s for %s", alias, this.organization.getId()), new Object[0]);
        }
        IdentityProviderRepresentation provider = kcResource.getIdentityProvider();
        Set<String> orgs = IdentityProviders.getAttributeMultivalued(provider.getConfig(), "home.idp.discovery.org");
        if (!orgs.contains(this.organization.getId())) {
            throw new NotFoundException(String.format("%s not found", alias));
        }
        return new IdentityProviderResource(this, this.organization, alias, kcResource);
    }

    @GET
    @Produces(value={"application/json"})
    public Stream<IdentityProviderRepresentation> getIdentityProviders() {
        return this.realm.getIdentityProvidersStream().filter(provider -> this.canViewIdp()).filter(this::idpInOrg).map(provider -> (IdentityProviderRepresentation)StripSecretsUtils.stripSecrets((KeycloakSession)this.session, (Object)ModelToRepresentation.toRepresentation((RealmModel)this.realm, (IdentityProviderModel)provider)));
    }

    protected void idpDefaults(IdentityProviderRepresentation representation, Optional<LinkIdp> linkIdp) {
        String syncMode = linkIdp.map(LinkIdp::getSyncMode).orElse(Optional.ofNullable(this.realm.getAttribute("_providerConfig.orgs.defaults.syncMode")).orElse("FORCE"));
        String postBrokerFlow = linkIdp.map(LinkIdp::getPostBrokerFlow).orElse(Optional.ofNullable(this.realm.getAttribute("_providerConfig.orgs.defaults.postBrokerFlow")).orElse("post org broker login"));
        log.debugf("using syncMode %s, postBrokerFlow %s for idp %s", (Object)syncMode, (Object)postBrokerFlow, (Object)representation.getAlias());
        representation.getConfig().put("syncMode", syncMode);
        representation.getConfig().put("hideOnLoginPage", "true");
        representation.setPostBrokerLoginFlowAlias(postBrokerFlow);
        Boolean isSharedIdpsConfigEnabled = this.realm.getAttribute("_providerConfig.orgs.config.sharedIdps", Boolean.valueOf(false));
        if (isSharedIdpsConfigEnabled.booleanValue()) {
            IdentityProviders.addMultiOrganization(this.organization, representation);
        } else {
            representation.getConfig().put("home.idp.discovery.shared", "false");
            IdentityProviders.setAttributeMultivalued(representation.getConfig(), "home.idp.discovery.org", Set.of(this.organization.getId()));
        }
    }

    private void deactivateOtherIdps(IdentityProviderRepresentation representation, boolean unlink, boolean disable, String orgId) {
        if (representation.isEnabled()) {
            this.realm.getIdentityProvidersStream().filter(provider -> this.idpInOrg((IdentityProviderModel)provider)).forEach(provider -> {
                if (disable) {
                    provider.setEnabled(false);
                }
                if (unlink) {
                    IdentityProviders.removeOrganization(orgId, provider);
                }
                this.realm.updateIdentityProvider(provider);
            });
        }
    }

    private Response createdResponse(IdentityProviderRepresentation representation) {
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(representation.getAlias()).build(new Object[0])).build();
    }

    private LinkIdp linkFromRep(IdentityProviderRepresentation representation) {
        LinkIdp link = new LinkIdp();
        link.setAlias(representation.getAlias());
        link.setPostBrokerFlow(representation.getPostBrokerLoginFlowAlias());
        Map config = representation.getConfig();
        if (config != null) {
            link.setSyncMode((String)config.get("syncMode"));
        }
        return link;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createIdentityProvider(IdentityProviderRepresentation representation) {
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs() && !((OrganizationAdminAuth)this.auth).hasOrgManageIdentityProviders(this.organization)) {
            throw new NotAuthorizedException((Object)String.format("Insufficient permission to create identity providers for %s", this.organization.getId()), new Object[0]);
        }
        this.idpDefaults(representation, Optional.of(this.linkFromRep(representation)));
        this.deactivateOtherIdps(representation, false, true, this.organization.getId());
        Response resp = this.getIdpResource().create(representation);
        if (resp.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return this.createdResponse(representation);
        }
        return resp;
    }

    @POST
    @Path(value="link")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response linkIdp(LinkIdp linkIdp) {
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs()) {
            throw new NotAuthorizedException((Object)String.format("Insufficient permission to link identity providers for %s", this.organization.getId()), new Object[0]);
        }
        IdentityProviderModel idp = this.realm.getIdentityProviderByAlias(linkIdp.getAlias());
        if (idp == null) {
            throw new NotFoundException(String.format("No IdP found with alias %s", linkIdp.getAlias()));
        }
        if (!idp.isEnabled()) {
            throw new BadRequestException(String.format("Cannot link disabled IdP %s", linkIdp.getAlias()));
        }
        IdentityProviderRepresentation representation = ModelToRepresentation.toRepresentation((RealmModel)this.realm, (IdentityProviderModel)idp);
        this.idpDefaults(representation, Optional.of(linkIdp));
        if (!Strings.isNullOrEmpty((String)linkIdp.getSyncMode())) {
            representation.getConfig().put("syncMode", linkIdp.getSyncMode());
        }
        if (!Strings.isNullOrEmpty((String)linkIdp.getPostBrokerFlow())) {
            representation.setPostBrokerLoginFlowAlias(linkIdp.getPostBrokerFlow());
        }
        this.deactivateOtherIdps(representation, true, false, this.organization.getId());
        try {
            IdentityProviderModel updated = RepresentationToModel.toModel((RealmModel)this.realm, (IdentityProviderRepresentation)representation, (KeycloakSession)this.session);
            this.realm.updateIdentityProvider(updated);
            return this.createdResponse(representation);
        }
        catch (Exception e) {
            throw new InternalServerErrorException(String.format("Error updating IdP %s", representation.getAlias()), (Throwable)e);
        }
    }

    @POST
    @Path(value="import-config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> importConfig(Map<String, Object> data) throws IOException {
        return this.getIdpResource().importFrom(data);
    }

    @POST
    @Path(value="import-config")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Map<String, String> importConfig() throws IOException {
        return this.getIdpResource().importFrom();
    }

    private boolean idpInOrg(IdentityProviderModel provider) {
        Set<String> orgs = IdentityProviders.getAttributeMultivalued(provider.getConfig(), "home.idp.discovery.org");
        return orgs.contains(this.organization.getId());
    }

    private org.keycloak.services.resources.admin.IdentityProvidersResource getIdpResource() {
        OrganizationAdminPermissionEvaluator authEval = new OrganizationAdminPermissionEvaluator(this.organization, (OrganizationAdminAuth)this.auth, this.permissions);
        return new org.keycloak.services.resources.admin.IdentityProvidersResource(this.realm, this.session, (AdminPermissionEvaluator)authEval, this.adminEvent);
    }

    @Path(value="test-ldap-connection")
    @POST
    @Consumes(value={"application/json"})
    public Response testLDAPConnection(TestLdapConnectionRepresentation config) {
        try {
            LDAPServerCapabilitiesManager.testLDAP((TestLdapConnectionRepresentation)config, (KeycloakSession)this.session, (RealmModel)this.realm);
            return Response.noContent().build();
        }
        catch (Exception e) {
            throw new BadRequestException("LDAP test error");
        }
    }

    @POST
    @Path(value="ldap")
    @Consumes(value={"application/json"})
    public Response create(ComponentRepresentation rep) {
        return null;
    }

    private boolean canViewIdp() {
        Boolean isSharedIdpsConfigEnabled = this.realm.getAttribute("_providerConfig.orgs.config.sharedIdps", Boolean.valueOf(false));
        if (!isSharedIdpsConfigEnabled.booleanValue()) {
            return true;
        }
        return ((OrganizationAdminAuth)this.auth).hasOrgViewIdentityProviders(this.organization) || ((OrganizationAdminAuth)this.auth).hasViewOrgs();
    }

    private boolean canManageIdp() {
        Boolean isSharedIdpsConfigEnabled = this.realm.getAttribute("_providerConfig.orgs.config.sharedIdps", Boolean.valueOf(false));
        if (!isSharedIdpsConfigEnabled.booleanValue()) {
            return true;
        }
        return ((OrganizationAdminAuth)this.auth).hasManageOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgManageIdentityProviders(this.organization);
    }
}

