/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.representation.Invitation;
import io.phasetwo.service.representation.InvitationRequest;
import io.phasetwo.service.resource.Converters;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.resource.OrganizationResourceType;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.validation.Valid;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.email.freemarker.FreeMarkerEmailTemplateProvider;
import org.keycloak.email.freemarker.beans.ProfileBean;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class InvitationsResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(InvitationsResource.class);
    private final OrganizationModel organization;

    public InvitationsResource(OrganizationAdminResource parent, OrganizationModel organization) {
        super(parent);
        this.organization = organization;
    }

    @POST
    @Path(value="")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createInvitation(@Valid InvitationRequest invitation) {
        String email = invitation.getEmail();
        log.debugf("Create invitation for %s %s %s", (Object)email, (Object)this.realm.getName(), (Object)this.organization.getId());
        this.canManage();
        if (email == null || !InvitationsResource.isValidEmail(email)) {
            throw new BadRequestException("Invalid email: " + email);
        }
        if (!this.canSetRoles(invitation.getRoles())) {
            throw new BadRequestException("Unknown role in list.");
        }
        email = email.toLowerCase();
        String link = Optional.ofNullable(invitation.getRedirectUri()).orElse("");
        if (this.organization.getInvitationsByEmail(email).count() > 0L) {
            log.infof("invitation for %s %s %s already exists. .", (Object)email, (Object)this.realm.getName(), (Object)this.organization.getId());
            throw new ClientErrorException(String.format("Invitation for %s already exists.", email), Response.Status.CONFLICT);
        }
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)this.realm, (String)email);
        if (user != null && this.organization.hasMembership(user)) {
            log.infof("%s is already a member of %s", (Object)email, (Object)this.organization.getId());
            throw new ClientErrorException(String.format("%s is already a member of this organization.", email), Response.Status.CONFLICT);
        }
        try {
            UserModel inviter = null;
            inviter = invitation.getInviterId() == null || invitation.getInviterId().equals("") ? ((OrganizationAdminAuth)this.auth).getUser() : this.session.users().getUserById(this.realm, invitation.getInviterId());
            InvitationModel i = this.organization.addInvitation(email, inviter);
            i.setUrl(link);
            if (invitation.getRoles() != null) {
                i.setRoles(invitation.getRoles());
            }
            if (invitation.getAttributes() != null && invitation.getAttributes().size() > 0) {
                invitation.getAttributes().entrySet().forEach(e -> i.setAttribute((String)e.getKey(), (List)e.getValue()));
            }
            Invitation o = Converters.convertInvitationModelToInvitation(i);
            log.debugf("Made invitation %s", (Object)o);
            this.adminEvent.resource(OrganizationResourceType.INVITATION.name()).operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), o.getId()).representation((Object)o).success();
            URI location = this.session.getContext().getUri().getAbsolutePathBuilder().path(o.getId()).build(new Object[0]);
            if (invitation.isSend()) {
                try {
                    this.sendInvitationEmail(email, this.session, this.realm, inviter, link, o.getAttributes());
                }
                catch (Exception e2) {
                    log.warn((Object)"Unable to send invitation email", (Throwable)e2);
                }
            }
            return Response.created((URI)location).build();
        }
        catch (Exception e3) {
            throw new InternalServerErrorException((Throwable)e3);
        }
    }

    boolean canSetRoles(Collection<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return true;
        }
        Set orgRoles = this.organization.getRolesStream().map(r -> r.getName()).collect(Collectors.toSet());
        for (String role : roles) {
            if (orgRoles.contains(role)) continue;
            return false;
        }
        return true;
    }

    void sendInvitationEmail(String email, KeycloakSession session, RealmModel realm, UserModel inviter, String link, Map<String, List<String>> attributes) throws Exception {
        EmailTemplateProvider emailTemplateProvider = (EmailTemplateProvider)session.getProvider(EmailTemplateProvider.class);
        Method sendMethod = FreeMarkerEmailTemplateProvider.class.getDeclaredMethod("send", String.class, List.class, String.class, Map.class, String.class);
        sendMethod.setAccessible(true);
        String realmName = Strings.isNullOrEmpty((String)realm.getDisplayName()) ? realm.getName() : realm.getDisplayName();
        String orgName = Strings.isNullOrEmpty((String)this.organization.getDisplayName()) ? this.organization.getName() : this.organization.getDisplayName();
        String inviterName = this.getInviterName(inviter).orElse("");
        String templateName = "invitation-email.ftl";
        String subjectKey = "invitationEmailSubject";
        ImmutableList subjectAttributes = ImmutableList.of((Object)realmName, (Object)orgName, (Object)inviterName);
        HashMap bodyAttributes = Maps.newHashMap();
        bodyAttributes.put("email", email);
        bodyAttributes.put("realmName", realmName);
        bodyAttributes.put("orgName", orgName);
        bodyAttributes.put("inviterName", inviterName);
        bodyAttributes.put("inviter", new ProfileBean(inviter, session));
        bodyAttributes.put("link", link);
        bodyAttributes.put("attributes", attributes);
        emailTemplateProvider.setRealm(realm).setUser(this.user).setAttribute("realmName", (Object)realmName);
        sendMethod.invoke((Object)emailTemplateProvider, subjectKey, subjectAttributes, templateName, bodyAttributes, email);
    }

    Optional<String> getInviterName(UserModel user) {
        if (user == null) {
            return Optional.empty();
        }
        StringBuilder o = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)user.getFirstName())) {
            o.append(user.getFirstName());
        }
        if (!Strings.isNullOrEmpty((String)user.getLastName())) {
            if (o.length() > 0) {
                o.append(" ");
            }
            o.append(user.getLastName());
        }
        if (!Strings.isNullOrEmpty((String)user.getEmail())) {
            if (o.length() > 0) {
                o.append(" ").append("(");
            }
            o.append(user.getEmail());
            if (o.length() > user.getEmail().length()) {
                o.append(")");
            }
        }
        return Optional.ofNullable(Strings.emptyToNull((String)o.toString()));
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public Stream<Invitation> listInvitations(@QueryParam(value="search") String searchQuery, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        log.debugf("Get invitations for %s %s", (Object)this.realm.getName(), (Object)this.organization.getId());
        Optional<String> search = Optional.ofNullable(searchQuery);
        firstResult = firstResult != null ? firstResult : 0;
        maxResults = maxResults != null ? maxResults : 100;
        return this.organization.getInvitationsStream().filter(i -> !search.isPresent() || i.getEmail().contains((CharSequence)search.get())).skip(firstResult.intValue()).limit(maxResults.intValue()).map(i -> Converters.convertInvitationModelToInvitation(i));
    }

    @GET
    @Path(value="count")
    @Produces(value={"application/json"})
    public Long countInvitations() {
        log.debugf("countInvitations %s %s", (Object)this.realm.getName(), (Object)this.organization.getId());
        return this.organization.getInvitationsCount();
    }

    @GET
    @Path(value="{invitationId}")
    @Produces(value={"application/json"})
    public Invitation getInvitation(@PathParam(value="invitationId") String invitationId) {
        log.debugf("Get invitation for %s %s %s", (Object)this.realm.getName(), (Object)this.organization.getId(), (Object)invitationId);
        InvitationModel invitation = this.organization.getInvitation(invitationId);
        if (invitation == null) {
            throw new NotFoundException(String.format("No invitation with id %s", invitationId));
        }
        return Converters.convertInvitationModelToInvitation(invitation);
    }

    @PUT
    @Path(value="{invitationId}/resend-email")
    public Response resendEmail(@PathParam(value="invitationId") String invitationId) {
        log.debugf("Resend invitation for %s %s %s", (Object)this.realm.getName(), (Object)this.organization.getId(), (Object)invitationId);
        InvitationModel invitation = this.organization.getInvitation(invitationId);
        if (invitation == null) {
            throw new NotFoundException(String.format("No invitation with id %s", invitationId));
        }
        UserModel inviter = invitation.getInviter();
        if (inviter == null) {
            inviter = ((OrganizationAdminAuth)this.auth).getUser();
        }
        try {
            this.sendInvitationEmail(invitation.getEmail(), this.session, this.realm, inviter, Optional.ofNullable(invitation.getUrl()).orElse(""), invitation.getAttributes());
        }
        catch (Exception e) {
            log.warn((Object)"Unable to send invitation email", (Throwable)e);
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{invitationId}")
    public Response removeInvitation(@PathParam(value="invitationId") String invitationId) {
        this.canManage();
        InvitationModel invitation = this.organization.getInvitationsStream().filter(i -> i.getId().equals(invitationId)).findAny().orElse(null);
        if (invitation == null) {
            throw new NotFoundException(String.format("No invitation with id %s", invitationId));
        }
        this.organization.revokeInvitation(invitationId);
        this.adminEvent.resource(OrganizationResourceType.INVITATION.name()).operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri(), invitation.getId()).representation((Object)Converters.convertInvitationModelToInvitation(invitation)).success();
        return Response.status((int)204).build();
    }

    private void canManage() {
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs() && !((OrganizationAdminAuth)this.auth).hasOrgManageInvitations(this.organization)) {
            throw new NotAuthorizedException((Object)String.format("User %s doesn't have permission to manage invitations in org %s", ((OrganizationAdminAuth)this.auth).getUser().getId(), this.organization.getName()), new Object[0]);
        }
    }

    private static InternetAddress getValidEmail(String email) throws AddressException {
        Objects.requireNonNull(email, "email must not be null to validate");
        if (email.startsWith("mailto:")) {
            email = email.substring(7);
        }
        InternetAddress emailAddr = new InternetAddress(email);
        emailAddr.validate();
        return emailAddr;
    }

    private static boolean isValidEmail(String email) {
        try {
            InvitationsResource.getValidEmail(email);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

