/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.common.base.Strings;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.resource.OrganizationResourceProviderFactory;
import io.phasetwo.service.resource.OrganizationResourceType;
import io.phasetwo.service.util.ActiveOrganization;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class MembersResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(MembersResource.class);
    private final OrganizationModel organization;

    public MembersResource(OrganizationAdminResource parent, OrganizationModel organization) {
        super(parent);
        this.organization = organization;
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public Stream<UserRepresentation> getMembers(@QueryParam(value="search") String searchQuery, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        log.debugf("Get members for %s %s [%s]", (Object)this.realm.getName(), (Object)this.organization.getId(), (Object)searchQuery);
        firstResult = firstResult != null ? firstResult : 0;
        maxResults = maxResults != null ? maxResults : 100;
        return this.organization.searchForMembersStream(searchQuery, firstResult, maxResults).map(m -> ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)m));
    }

    @GET
    @Path(value="count")
    @Produces(value={"application/json"})
    public Long getMembersCount() {
        log.debugf("Get members count for %s %s", (Object)this.realm.getName(), (Object)this.organization.getId());
        return this.organization.getMembersCount();
    }

    @DELETE
    @Path(value="{userId}")
    public Response removeMember(@PathParam(value="userId") String userId) {
        this.canDelete(userId);
        log.debugf("Remove member %s from %s %s", (Object)userId, (Object)this.realm.getName(), (Object)this.organization.getId());
        UserModel member = this.session.users().getUserById(this.realm, userId);
        if (!Strings.isNullOrEmpty((String)member.getUsername()) && member.getUsername().equals(OrganizationResourceProviderFactory.getDefaultAdminUsername(this.organization))) {
            throw new ForbiddenException("Cannot remove default organization user.");
        }
        if (!this.organization.hasMembership(member)) {
            throw new NotFoundException();
        }
        ActiveOrganization activeOrganizationUtil = ActiveOrganization.fromContext(this.session, this.realm, member);
        if (activeOrganizationUtil.isValid() && activeOrganizationUtil.isCurrentActiveOrganization(this.organization.getId())) {
            member.setAttribute("org.ro.active", new ArrayList());
            EventBuilder event = new EventBuilder(this.realm, this.session, this.connection);
            event.event(EventType.UPDATE_PROFILE).user(this.user).detail("removed_active_organization_id", activeOrganizationUtil.getOrganization().getId()).success();
        }
        this.organization.revokeMembership(member);
        this.adminEvent.resource(OrganizationResourceType.ORGANIZATION_MEMBERSHIP.name()).operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation((Object)userId).success();
        return Response.noContent().build();
    }

    @GET
    @Path(value="{userId}")
    public Response getMember(@PathParam(value="userId") String userId) {
        log.debugf("Check membership %s for %s %s", (Object)userId, (Object)this.realm.getName(), (Object)this.organization.getId());
        UserModel member = this.session.users().getUserById(this.realm, userId);
        if (member != null && this.organization.hasMembership(member)) {
            return Response.noContent().build();
        }
        throw new NotFoundException();
    }

    @PUT
    @Path(value="{userId}")
    @Produces(value={"application/json"})
    public Response addMember(@PathParam(value="userId") String userId) {
        log.debugf("Add %s as member for %s %s", (Object)userId, (Object)this.realm.getName(), (Object)this.organization.getId());
        this.canManage();
        UserModel member = this.session.users().getUserById(this.realm, userId);
        if (member != null) {
            if (!this.organization.hasMembership(member)) {
                this.organization.grantMembership(member);
                this.adminEvent.resource(OrganizationResourceType.ORGANIZATION_MEMBERSHIP.name()).operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation((Object)userId).success();
            }
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().build(new Object[0])).build();
        }
        throw new NotFoundException();
    }

    private void canManage() {
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs() && !((OrganizationAdminAuth)this.auth).hasOrgManageMembers(this.organization)) {
            throw new NotAuthorizedException((Object)String.format("User %s doesn't have permission to manage members in org %s", ((OrganizationAdminAuth)this.auth).getUser().getId(), this.organization.getName()), new Object[0]);
        }
    }

    private void canDelete(String userId) {
        if (!userId.equals(this.user.getId())) {
            this.canManage();
        }
    }
}

