/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.common.collect.ImmutableList;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.model.jpa.entity.ExtOrganizationEntity;
import io.phasetwo.service.model.jpa.entity.InvitationEntity;
import io.phasetwo.service.model.jpa.entity.OrganizationMemberEntity;
import jakarta.ws.rs.NotAuthorizedException;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.resources.admin.AdminAuth;

public class OrganizationAdminAuth
extends AdminAuth {
    private static final Logger log = Logger.getLogger(OrganizationAdminAuth.class);
    public static final String ROLE_CREATE_ORGANIZATION = "create-organization";
    public static final String ROLE_VIEW_ORGANIZATION = "view-organizations";
    public static final String ROLE_MANAGE_ORGANIZATION = "manage-organizations";
    public static final String ORG_ROLE_VIEW_ORGANIZATION = "view-organization";
    public static final String ORG_ROLE_MANAGE_ORGANIZATION = "manage-organization";
    public static final String ORG_ROLE_VIEW_MEMBERS = "view-members";
    public static final String ORG_ROLE_MANAGE_MEMBERS = "manage-members";
    public static final String ORG_ROLE_VIEW_ROLES = "view-roles";
    public static final String ORG_ROLE_MANAGE_ROLES = "manage-roles";
    public static final String ORG_ROLE_VIEW_INVITATIONS = "view-invitations";
    public static final String ORG_ROLE_MANAGE_INVITATIONS = "manage-invitations";
    public static final String ORG_ROLE_VIEW_IDENTITY_PROVIDERS = "view-identity-providers";
    public static final String ORG_ROLE_MANAGE_IDENTITY_PROVIDERS = "manage-identity-providers";
    public static final String[] DEFAULT_ORG_ROLES = new String[]{"view-organization", "manage-organization", "view-members", "manage-members", "view-roles", "manage-roles", "view-invitations", "manage-invitations", "view-identity-providers", "manage-identity-providers"};
    static String ORGANIZATIONS_CLAIM = "organizations";

    public OrganizationAdminAuth(RealmModel realm, AccessToken token, UserModel user, ClientModel client) {
        super(realm, token, user, client);
        log.debugf("Realm passed to ctr is %s", (Object)realm.getName());
    }

    void requireCreateOrg() {
        if (!this.hasAppRole(this.getClient(), ROLE_CREATE_ORGANIZATION)) {
            throw new NotAuthorizedException((Object)ROLE_CREATE_ORGANIZATION, new Object[0]);
        }
    }

    boolean hasCreateOrg() {
        return this.hasAppRole(this.getClient(), ROLE_CREATE_ORGANIZATION);
    }

    void requireViewOrgs() {
        if (!this.hasAppRole(this.getClient(), ROLE_VIEW_ORGANIZATION)) {
            throw new NotAuthorizedException((Object)ROLE_VIEW_ORGANIZATION, new Object[0]);
        }
    }

    boolean hasViewOrgs() {
        return this.hasAppRole(this.getClient(), ROLE_VIEW_ORGANIZATION);
    }

    void requireManageOrgs() {
        if (!this.hasAppRole(this.getClient(), ROLE_MANAGE_ORGANIZATION)) {
            throw new NotAuthorizedException((Object)ROLE_MANAGE_ORGANIZATION, new Object[0]);
        }
    }

    boolean hasManageOrgs() {
        return this.hasAppRole(this.getClient(), ROLE_MANAGE_ORGANIZATION);
    }

    boolean hasManageRealm() {
        return this.hasAppRole(this.getClient(), AdminRoles.MANAGE_REALM);
    }

    @Deprecated
    void requireOrgInRealm(ExtOrganizationEntity orgEntity) {
        if (!orgEntity.getRealmId().equals(this.getRealm().getId())) {
            throw new NotAuthorizedException((Object)String.format("Organization %s not in realm %s", orgEntity.getId(), this.getRealm().getName()), new Object[0]);
        }
    }

    void requireOrgInRealm(OrganizationModel org) {
        if (!this.isOrgInRealm(org)) {
            throw new NotAuthorizedException((Object)String.format("Organization %s not in realm %s", org.getId(), this.getRealm().getName()), new Object[0]);
        }
    }

    boolean isOrgInRealm(OrganizationModel org) {
        return org.getRealm().getId().equals(this.getRealm().getId());
    }

    @Deprecated
    void requireUserInRealm(UserEntity userEntity) {
        if (!userEntity.getRealmId().equals(this.getRealm().getId())) {
            throw new NotAuthorizedException((Object)String.format("User %s not in realm %s", userEntity.getId(), this.getRealm().getName()), new Object[0]);
        }
    }

    @Deprecated
    void requireInvitationInOrgInRealm(InvitationEntity inviteEntity, ExtOrganizationEntity orgEntity) {
        if (!inviteEntity.getOrganization().equals(orgEntity)) {
            throw new NotAuthorizedException((Object)String.format("Invitation %s not in org %s", inviteEntity.getId(), orgEntity.getId()), new Object[0]);
        }
        this.requireOrgInRealm(orgEntity);
    }

    void requireInvitationInOrgInRealm(InvitationModel invite, OrganizationModel org) {
        if (!this.isInvitationInOrgInRealm(invite, org)) {
            throw new NotAuthorizedException((Object)String.format("Invitation %s not in org %s", invite.getId(), org.getId()), new Object[0]);
        }
    }

    boolean isInvitationInOrgInRealm(InvitationModel invite, OrganizationModel org) {
        return invite.getOrganization().equals(org) && this.isOrgInRealm(org);
    }

    @Deprecated
    void requireUserInOrgInRealm(UserEntity userEntity, OrganizationMemberEntity memberEntity, ExtOrganizationEntity orgEntity) {
        if (userEntity == null || memberEntity == null || orgEntity != null || !userEntity.getId().equals(memberEntity.getUserId()) || !memberEntity.getOrganization().equals(orgEntity)) {
            throw new NotAuthorizedException((Object)String.format("User %s not in org %s", userEntity.getId(), orgEntity.getId()), new Object[0]);
        }
        this.requireOrgInRealm(orgEntity);
    }

    boolean hasOrgViewOrg(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_VIEW_ORGANIZATION) || org.hasMembership(this.getUser());
    }

    boolean hasOrgManageOrg(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_MANAGE_ORGANIZATION);
    }

    boolean hasOrgViewMembers(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_VIEW_MEMBERS);
    }

    boolean hasOrgManageMembers(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_MANAGE_MEMBERS);
    }

    boolean hasOrgViewInvitations(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_VIEW_INVITATIONS);
    }

    boolean hasOrgManageInvitations(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_MANAGE_INVITATIONS);
    }

    boolean hasOrgViewRoles(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_VIEW_ROLES);
    }

    boolean hasOrgManageRoles(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_MANAGE_ROLES);
    }

    boolean hasOrgViewIdentityProviders(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_VIEW_IDENTITY_PROVIDERS);
    }

    boolean hasOrgManageIdentityProviders(OrganizationModel org) {
        return this.hasOrgRole(org, ORG_ROLE_MANAGE_IDENTITY_PROVIDERS);
    }

    boolean hasOrgAll(OrganizationModel org) {
        for (String role : DEFAULT_ORG_ROLES) {
            if (this.hasOrgRole(org, role)) continue;
            return false;
        }
        return true;
    }

    boolean hasOrgViewAll(OrganizationModel org) {
        for (String role : DEFAULT_ORG_ROLES) {
            if (!role.startsWith("view") || this.hasOrgRole(org, role)) continue;
            return false;
        }
        return true;
    }

    boolean hasOrgManageAll(OrganizationModel org) {
        for (String role : DEFAULT_ORG_ROLES) {
            if (!role.startsWith("manage") || this.hasOrgRole(org, role)) continue;
            return false;
        }
        return true;
    }

    private List<String> getOrganizationRoles(OrganizationModel org) {
        Object o = this.getToken().getOtherClaims().get(ORGANIZATIONS_CLAIM);
        if (o == null || !(o instanceof Map)) {
            return ImmutableList.of();
        }
        Map orgs = (Map)o;
        Object os = orgs.get(org.getId());
        if (os == null || !(os instanceof Map)) {
            return ImmutableList.of();
        }
        Map osrg = (Map)os;
        Object rs = osrg.get("roles");
        if (rs == null || !(rs instanceof List)) {
            return ImmutableList.of();
        }
        return (List)rs;
    }

    private boolean hasOrgRoleInToken(OrganizationModel org, String roleName) {
        return this.getOrganizationRoles(org).contains(roleName);
    }

    private boolean hasOrgRole(OrganizationModel org, String roleName) {
        OrganizationRoleModel role = org.getRoleByName(roleName);
        boolean has = role != null && role.hasRole(this.getUser());
        log.debugf("%s has role %s? %b", (Object)this.getUser().getId(), (Object)roleName, (Object)has);
        return has;
    }

    private void requireOrgRole(OrganizationModel org, String roleName) {
        if (!this.hasOrgRole(org, roleName)) {
            throw new NotAuthorizedException((Object)String.format("User %s doesn't have role %s in org %s", this.getUser().getId(), roleName, org.getName()), new Object[0]);
        }
    }
}

