/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import jakarta.ws.rs.ForbiddenException;
import org.jboss.logging.Logger;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.ClientPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.GroupPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.RealmPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.RolePermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.UserPermissionEvaluator;

public class OrganizationAdminPermissionEvaluator
implements AdminPermissionEvaluator {
    private static final Logger log = Logger.getLogger(OrganizationAdminPermissionEvaluator.class);
    private final AdminPermissionEvaluator permissions;
    private final OrganizationAdminAuth auth;
    private final OrganizationModel organization;

    public OrganizationAdminPermissionEvaluator(OrganizationModel organization, OrganizationAdminAuth auth, AdminPermissionEvaluator permissions) {
        this.organization = organization;
        this.auth = auth;
        this.permissions = permissions;
    }

    public AdminAuth adminAuth() {
        return this.permissions.adminAuth();
    }

    public void requireAnyAdminRole() {
        this.permissions.requireAnyAdminRole();
    }

    public ClientPermissionEvaluator clients() {
        return this.permissions.clients();
    }

    public GroupPermissionEvaluator groups() {
        return this.permissions.groups();
    }

    public RealmPermissionEvaluator realm() {
        final RealmPermissionEvaluator realm = this.permissions.realm();
        return new RealmPermissionEvaluator(){

            public boolean canListRealms() {
                return realm.canListRealms();
            }

            public boolean canManageAuthorization() {
                return realm.canManageAuthorization();
            }

            public boolean canManageEvents() {
                return realm.canManageEvents();
            }

            public boolean canManageIdentityProviders() {
                log.debugf("canManageIdentityProviders %b", (Object)(realm.canManageIdentityProviders() || OrganizationAdminPermissionEvaluator.this.auth.hasOrgManageIdentityProviders(OrganizationAdminPermissionEvaluator.this.organization) ? 1 : 0));
                return realm.canManageIdentityProviders() || OrganizationAdminPermissionEvaluator.this.auth.hasOrgManageIdentityProviders(OrganizationAdminPermissionEvaluator.this.organization);
            }

            public boolean canManageRealm() {
                return realm.canManageRealm();
            }

            public boolean canViewAuthorization() {
                return realm.canViewAuthorization();
            }

            public boolean canViewEvents() {
                return realm.canViewEvents();
            }

            public boolean canViewIdentityProviders() {
                log.debugf("canViewIdentityProviders %b", (Object)(realm.canViewIdentityProviders() || OrganizationAdminPermissionEvaluator.this.auth.hasOrgViewIdentityProviders(OrganizationAdminPermissionEvaluator.this.organization) ? 1 : 0));
                return realm.canViewIdentityProviders() || OrganizationAdminPermissionEvaluator.this.auth.hasOrgViewIdentityProviders(OrganizationAdminPermissionEvaluator.this.organization);
            }

            public boolean canViewRealm() {
                return realm.canViewRealm();
            }

            public void requireManageAuthorization() {
                realm.requireManageAuthorization();
            }

            public void requireManageEvents() {
                realm.requireManageEvents();
            }

            public void requireManageIdentityProviders() {
                if (!this.canManageIdentityProviders()) {
                    throw new ForbiddenException();
                }
            }

            public void requireManageRealm() {
                realm.requireManageRealm();
            }

            public void requireViewAuthenticationFlows() {
                realm.requireViewAuthenticationFlows();
            }

            public void requireViewAuthorization() {
                realm.requireViewAuthorization();
            }

            public void requireViewClientAuthenticatorProviders() {
                realm.requireViewClientAuthenticatorProviders();
            }

            public void requireViewEvents() {
                realm.requireViewEvents();
            }

            public void requireViewIdentityProviders() {
                if (!this.canViewIdentityProviders()) {
                    throw new ForbiddenException();
                }
            }

            public void requireViewRealm() {
                realm.requireViewRealm();
            }

            public void requireViewRealmNameList() {
                realm.requireViewRealmNameList();
            }

            public void requireViewRequiredActions() {
                realm.requireViewRequiredActions();
            }
        };
    }

    public RolePermissionEvaluator roles() {
        return this.permissions.roles();
    }

    public UserPermissionEvaluator users() {
        return this.permissions.users();
    }
}

