/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.common.collect.ImmutableMap;
import io.phasetwo.service.auth.action.PortalLinkActionToken;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.representation.Organization;
import io.phasetwo.service.resource.Converters;
import io.phasetwo.service.resource.DomainsResource;
import io.phasetwo.service.resource.IdentityProvidersResource;
import io.phasetwo.service.resource.InvitationsResource;
import io.phasetwo.service.resource.MembersResource;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.resource.OrganizationResourceType;
import io.phasetwo.service.resource.RolesResource;
import jakarta.validation.Valid;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.UserModel;
import org.keycloak.services.Urls;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.theme.Theme;

public class OrganizationResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(OrganizationResource.class);
    protected final OrganizationModel organization;
    protected final String orgId;
    private static final String IDP_WIZARD_CLIENT = "idp-wizard";
    private static final String WIZARD_THEME = "wizard";

    public OrganizationResource(OrganizationAdminResource parent, OrganizationModel organization) {
        super(parent);
        this.organization = organization;
        this.orgId = organization.getId();
    }

    @Path(value="idps")
    public IdentityProvidersResource identityProviders() {
        if (((OrganizationAdminAuth)this.auth).hasViewOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgViewIdentityProviders(this.organization)) {
            return new IdentityProvidersResource(this, this.organization);
        }
        throw new NotAuthorizedException((Object)String.format("Insufficient permission to access identity providers for %s", this.organization.getId()), new Object[0]);
    }

    @Path(value="roles")
    public RolesResource roles() {
        if (((OrganizationAdminAuth)this.auth).hasViewOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgViewRoles(this.organization)) {
            return new RolesResource(this, this.organization);
        }
        throw new NotAuthorizedException((Object)String.format("Insufficient permission to access role for %s", this.organization.getId()), new Object[0]);
    }

    @Path(value="invitations")
    public InvitationsResource invitations() {
        if (((OrganizationAdminAuth)this.auth).hasViewOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgViewInvitations(this.organization)) {
            return new InvitationsResource(this, this.organization);
        }
        throw new NotAuthorizedException((Object)String.format("Insufficient permission to access invitation for %s", this.organization.getId()), new Object[0]);
    }

    @Path(value="members")
    public MembersResource members() {
        if (((OrganizationAdminAuth)this.auth).hasViewOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgViewMembers(this.organization)) {
            return new MembersResource(this, this.organization);
        }
        throw new NotAuthorizedException((Object)String.format("Insufficient permission to access members for %s", this.organization.getId()), new Object[0]);
    }

    @Path(value="domains")
    public DomainsResource domains() {
        if (((OrganizationAdminAuth)this.auth).hasViewOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgViewOrg(this.organization)) {
            return new DomainsResource(this, this.organization);
        }
        throw new NotAuthorizedException((Object)String.format("Insufficient permission to access domains for %s", this.organization.getId()), new Object[0]);
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public Response getOrg() {
        log.debugf("Get org for %s %s", (Object)this.realm.getName(), (Object)this.orgId);
        return Response.ok().entity((Object)Converters.convertOrganizationModelToOrganization(this.organization)).build();
    }

    @DELETE
    @Path(value="")
    @Produces(value={"application/json"})
    public Response deleteOrg() {
        log.debugf("Delete org for %s %s", (Object)this.realm.getName(), (Object)this.orgId);
        ((OrganizationAdminAuth)this.auth).requireManageOrgs();
        if (this.orgs.removeOrganization(this.realm, this.orgId)) {
            this.adminEvent.resource(OrganizationResourceType.ORGANIZATION.name()).operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation((Object)this.orgId).success();
        }
        return Response.status((int)204).build();
    }

    @PUT
    @Path(value="")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateOrg(@Valid Organization body) {
        log.debugf("Update org for %s", (Object)this.realm.getName());
        if (((OrganizationAdminAuth)this.auth).hasManageOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgManageOrg(this.organization)) {
            this.organization.setName(body.getName());
            this.organization.setDisplayName(body.getDisplayName());
            this.organization.setUrl(body.getUrl());
            this.organization.removeAttributes();
            if (body.getAttributes() != null) {
                body.getAttributes().forEach((k, v) -> this.organization.setAttribute((String)k, (List<String>)v));
            }
            if (body.getDomains() != null) {
                this.organization.setDomains(body.getDomains());
            }
            Organization o = Converters.convertOrganizationModelToOrganization(this.organization);
            this.adminEvent.resource(OrganizationResourceType.ORGANIZATION.name()).operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri(), o.getId()).representation((Object)o).success();
            return Response.noContent().build();
        }
        throw new NotAuthorizedException((Object)String.format("Insufficient permission to modify %s", this.organization.getId()), new Object[0]);
    }

    private Theme getTheme(String name) {
        try {
            return this.session.theme().getTheme(name, Theme.Type.LOGIN);
        }
        catch (IOException e) {
            return null;
        }
    }

    @POST
    @Path(value="portal-link")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response getPortalLink(@DefaultValue(value="") @FormParam(value="userId") String userId, @DefaultValue(value="") @FormParam(value="baseUri") String baseUri) {
        log.infof("requesting portal-link for user %s, org %s", (Object)userId, (Object)this.organization.getId());
        ClientModel idpWizardClient = this.session.clients().getClientByClientId(this.realm, IDP_WIZARD_CLIENT);
        Theme wizardTheme = this.getTheme(WIZARD_THEME);
        if (idpWizardClient == null || wizardTheme == null) {
            throw new BadRequestException("portal-link is only supported in paid Phase Two distributions");
        }
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs() && !((OrganizationAdminAuth)this.auth).hasOrgManageOrg(this.organization)) {
            throw new NotAuthorizedException((Object)String.format("Insufficient permission to create portal link for %s", this.organization.getId()), new Object[0]);
        }
        try {
            KeycloakUriInfo uriInfo = this.session.getContext().getUri();
            URI base = "".equals(baseUri) ? uriInfo.getBaseUri() : this.newUri(baseUri);
            String redirectUri = Urls.realmBase((URI)base).path(this.realm.getName()).path(WIZARD_THEME).build(new Object[0]).toString();
            log.debugf("%s redirectUri %s", (Object)IDP_WIZARD_CLIENT, (Object)redirectUri);
            UserModel user = null;
            if (userId != null && !"".equals(userId)) {
                user = this.session.users().getUserById(this.realm, userId);
            }
            if (user == null) {
                if (!((OrganizationAdminAuth)this.auth).hasManageOrgs() && !((OrganizationAdminAuth)this.auth).hasOrgAll(this.organization)) {
                    throw new NotAuthorizedException((Object)String.format("Insufficient permission to create portal link for %s", this.organization.getId()), new Object[0]);
                }
                user = this.session.users().getUserByUsername(this.realm, String.format("org-admin-%s", this.organization.getId()));
            }
            if (user == null) {
                throw new BadRequestException(String.format("User %s not found", userId));
            }
            log.debugf("Using user %s (%s) for portal-link", (Object)user.getUsername(), (Object)user.getId());
            if (!this.organization.hasMembership(user)) {
                throw new BadRequestException(String.format("User %s is not a member of this organization", userId));
            }
            for (String role : OrganizationAdminAuth.DEFAULT_ORG_ROLES) {
                OrganizationRoleModel roleModel = this.organization.getRoleByName(role);
                if (roleModel.hasRole(user)) continue;
                throw new BadRequestException(String.format("User has insufficient permissions. Needs %s.", role));
            }
            int validityInSecs = 86400;
            int absoluteExpirationInSecs = Time.currentTime() + validityInSecs;
            PortalLinkActionToken token = new PortalLinkActionToken(user.getId(), absoluteExpirationInSecs, this.organization.getId(), IDP_WIZARD_CLIENT, redirectUri);
            UriBuilder builder = this.actionTokenBuilder(uriInfo.getBaseUri(), token.serialize(this.session, this.realm, (UriInfo)uriInfo), IDP_WIZARD_CLIENT);
            String link = builder.build(new Object[]{this.realm.getName()}).toString();
            log.debugf("Created portal link for %s: %s", (Object)user.getUsername(), (Object)link);
            return Response.ok().entity((Object)ImmutableMap.of((Object)"user", (Object)user.getId(), (Object)"link", (Object)link, (Object)"redirect", (Object)redirectUri)).build();
        }
        catch (Exception e) {
            if (e instanceof WebApplicationException) {
                throw e;
            }
            log.warn((Object)"Error creating portal link", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private UriBuilder actionTokenBuilder(URI baseUri, String tokenString, String clientId) {
        log.debugf("baseUri: %s, tokenString: %s, clientId: %s", (Object)baseUri, (Object)tokenString, (Object)clientId);
        return Urls.realmBase((URI)baseUri).path(RealmsResource.class, "getLoginActionsService").path(LoginActionsService.class, "executeActionToken").queryParam("key", new Object[]{tokenString}).queryParam("client_id", new Object[]{clientId});
    }

    private URI newUri(String u) {
        try {
            return new URI(u);
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Error creating URI from %s", (Object)u);
            return null;
        }
    }
}

