/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.auto.service.AutoService;
import io.phasetwo.service.Orgs;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationProvider;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationResourceProvider;
import io.phasetwo.service.util.IdentityProviders;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resource.RealmResourceProviderFactory;

@AutoService(value={RealmResourceProviderFactory.class})
public class OrganizationResourceProviderFactory
implements RealmResourceProviderFactory {
    private static final Logger log = Logger.getLogger(OrganizationResourceProviderFactory.class);
    public static final String ID = "orgs";

    public String getId() {
        return ID;
    }

    public void close() {
    }

    public OrganizationResourceProvider create(KeycloakSession session) {
        log.debug((Object)"OrganizationResourceProviderFactory::create");
        return new OrganizationResourceProvider(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        log.debug((Object)"OrganizationResourceProviderFactory::postInit");
        factory.register(event -> {
            if (event instanceof RealmModel.RealmPostCreateEvent) {
                log.debug((Object)"RealmPostCreateEvent");
                this.realmPostCreate((RealmModel.RealmPostCreateEvent)event);
            } else if (event instanceof PostMigrationEvent) {
                log.debug((Object)"PostMigrationEvent");
                if (Orgs.KC_ORGS_SKIP_MIGRATION == null) {
                    log.info((Object)"initializing organization roles following migration");
                    KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, this::initRoles);
                }
            } else if (event instanceof RealmModel.RealmRemovedEvent) {
                log.debug((Object)"RealmRemovedEvent");
                this.realmRemoved((RealmModel.RealmRemovedEvent)event);
            } else if (event instanceof UserModel.UserRemovedEvent) {
                log.debug((Object)"UserRemovedEvent");
                this.userRemoved((UserModel.UserRemovedEvent)event);
            } else if (event instanceof OrganizationModel.OrganizationCreationEvent) {
                log.debug((Object)"OrganizationCreationEvent");
                this.organizationCreation((OrganizationModel.OrganizationCreationEvent)event);
            } else if (event instanceof OrganizationModel.OrganizationRemovedEvent) {
                log.debug((Object)"OrganizationRemovedEvent");
                this.organizationRemoved((OrganizationModel.OrganizationRemovedEvent)event);
            }
        });
    }

    private void initRoles(KeycloakSession session) {
        log.debug((Object)"OrganizationResourceProviderFactory::initRoles");
        RealmManager manager = new RealmManager(session);
        session.realms().getRealmsStream().forEach(realm -> {
            ClientModel client = realm.getMasterAdminClient();
            if (client.getRole("view-organizations") == null || client.getRole("manage-organizations") == null || client.getRole("create-organization") == null) {
                this.addMasterAdminRoles(manager, (RealmModel)realm);
            }
            if (!(realm.getName().equals(Config.getAdminRealm()) || (client = realm.getClientByClientId(manager.getRealmAdminClientId(realm))).getRole("view-organizations") != null && client.getRole("manage-organizations") != null && client.getRole("create-organization") != null)) {
                this.addRealmAdminRoles(manager, (RealmModel)realm);
            }
        });
    }

    private void realmPostCreate(RealmModel.RealmPostCreateEvent event) {
        RealmModel realm = event.getCreatedRealm();
        RealmManager manager = new RealmManager(event.getKeycloakSession());
        this.addMasterAdminRoles(manager, realm);
        if (!realm.getName().equals(Config.getAdminRealm())) {
            this.addRealmAdminRoles(manager, realm);
        }
    }

    private void addMasterAdminRoles(RealmManager manager, RealmModel realm) {
        RealmModel master = manager.getRealmByName(Config.getAdminRealm());
        RoleModel admin = master.getRole(AdminRoles.ADMIN);
        ClientModel client = realm.getMasterAdminClient();
        this.addRoles(client, admin);
    }

    private void addRealmAdminRoles(RealmManager manager, RealmModel realm) {
        ClientModel client = realm.getClientByClientId(manager.getRealmAdminClientId(realm));
        RoleModel admin = client.getRole(AdminRoles.REALM_ADMIN);
        this.addRoles(client, admin);
    }

    private void addRoles(ClientModel client, RoleModel parent) {
        String[] names;
        for (String name : names = new String[]{"view-organizations", "manage-organizations"}) {
            this.addRole(name, client, parent, true);
        }
        this.addRole("create-organization", client, parent, false);
    }

    private void addRole(String name, ClientModel client, RoleModel parent, boolean composite) {
        if (client.getRole(name) == null) {
            RoleModel role = client.addRole(name);
            role.setDescription("${role_" + name + "}");
            if (composite) {
                parent.addCompositeRole(role);
            }
        }
    }

    private void realmRemoved(RealmModel.RealmRemovedEvent event) {
        ((OrganizationProvider)event.getKeycloakSession().getProvider(OrganizationProvider.class)).removeOrganizations(event.getRealm());
    }

    private void userRemoved(UserModel.UserRemovedEvent event) {
        OrganizationProvider orgs = (OrganizationProvider)event.getKeycloakSession().getProvider(OrganizationProvider.class);
        orgs.getUserOrganizationsStream(event.getRealm(), event.getUser()).forEach(org -> {
            try {
                org.revokeMembership(event.getUser());
                org.getRolesStream().forEach(r -> {
                    if (r.hasRole(event.getUser())) {
                        r.revokeRole(event.getUser());
                    }
                });
            }
            catch (Exception e) {
                log.warn((Object)"error removing user from org", (Throwable)e);
            }
        });
    }

    private void organizationCreation(OrganizationModel.OrganizationCreationEvent event) {
        OrganizationModel org = event.getOrganization();
        for (String role : OrganizationAdminAuth.DEFAULT_ORG_ROLES) {
            org.addRole(role);
        }
        Boolean isCreateAdminUserConfigEnabled = event.getRealm().getAttribute("_providerConfig.orgs.config.createAdminUser", Boolean.valueOf(true));
        if (isCreateAdminUserConfigEnabled.booleanValue()) {
            String adminUsername = OrganizationResourceProviderFactory.getDefaultAdminUsername(org);
            UserModel user = event.getKeycloakSession().users().addUser(event.getRealm(), KeycloakModelUtils.generateId(), adminUsername, true, false);
            user.setEnabled(true);
            user.setEmail(String.format("%s@noreply.phasetwo.io", adminUsername));
            user.setEmailVerified(true);
            org.grantMembership(user);
            for (String role : OrganizationAdminAuth.DEFAULT_ORG_ROLES) {
                OrganizationRoleModel roleModel = org.getRoleByName(role);
                roleModel.grantRole(user);
            }
        }
    }

    private void organizationRemoved(OrganizationModel.OrganizationRemovedEvent event) {
        OrganizationModel org = event.getOrganization();
        try {
            org.getIdentityProvidersStream().forEach(idp -> IdentityProviders.removeOrganization(org.getId(), idp));
        }
        catch (Exception e) {
            log.warnf("Couldn't remove identity providers on organizationRemoved. Likely because this follows a realmRemoved event. %s", (Object)e.getMessage());
        }
        try {
            UserModel user = event.getKeycloakSession().users().getUserByUsername(event.getRealm(), OrganizationResourceProviderFactory.getDefaultAdminUsername(event.getOrganization()));
            if (user != null) {
                boolean removed = event.getKeycloakSession().users().removeUser(event.getRealm(), user);
                log.debugf("User removed on deletion of org %s? %b", (Object)event.getOrganization().getId(), (Object)removed);
            } else {
                log.warnf("Default org admin %s for org %s doesn't exist. Skipping deletion on org removal.", (Object)OrganizationResourceProviderFactory.getDefaultAdminUsername(event.getOrganization()), (Object)event.getOrganization().getId());
            }
        }
        catch (Exception e) {
            log.warnf("Couldn't remove default org admin user on organizationRemoved. Likely because this follows a realmRemoved event. %s", (Object)e.getMessage());
        }
    }

    public static String getDefaultAdminUsername(OrganizationModel org) {
        return String.format("org-admin-%s", org.getId());
    }
}

