/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.phasetwo.service.importexport.KeycloakOrgsExportConverter;
import io.phasetwo.service.importexport.KeycloakOrgsImportConverter;
import io.phasetwo.service.importexport.representation.KeycloakOrgsRepresentation;
import io.phasetwo.service.importexport.representation.OrganizationRepresentation;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationProvider;
import io.phasetwo.service.representation.Organization;
import io.phasetwo.service.representation.OrganizationsConfig;
import io.phasetwo.service.resource.Converters;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.resource.OrganizationResource;
import io.phasetwo.service.resource.OrganizationResourceType;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.utils.SearchQueryUtils;

public class OrganizationsResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(OrganizationsResource.class);

    public OrganizationsResource(KeycloakSession session) {
        super(session);
    }

    @Path(value="{orgId}")
    public OrganizationResource getOrg(@PathParam(value="orgId") String orgId) {
        OrganizationModel org = this.orgs.getOrganizationById(this.realm, orgId);
        if (org == null) {
            throw new NotFoundException(String.format("%s not found", orgId));
        }
        if ((((OrganizationAdminAuth)this.auth).hasViewOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgViewOrg(org)) && ((OrganizationAdminAuth)this.auth).isOrgInRealm(org)) {
            return new OrganizationResource(this, org);
        }
        throw new NotAuthorizedException((Object)String.format("Insufficient permission to access %s", orgId), new Object[0]);
    }

    @GET
    @Path(value="me")
    @Produces(value={"application/json"})
    public Response me() {
        HashMap claim = Maps.newHashMap();
        this.orgs.getUserOrganizationsStream(this.realm, this.user).forEach(o -> {
            ArrayList roles = Lists.newArrayList();
            o.getRolesStream().forEach(r -> {
                if (r.hasRole(this.user)) {
                    roles.add(r.getName());
                }
            });
            HashMap org = Maps.newHashMap();
            org.put("name", o.getName());
            if (o.getDisplayName() != null) {
                org.put("displayName", o.getDisplayName());
            }
            if (o.getUrl() != null) {
                org.put("url", o.getUrl());
            }
            org.put("attributes", o.getAttributes());
            org.put("roles", roles);
            claim.put(o.getId(), org);
        });
        return Response.ok((Object)claim).build();
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public Stream<Organization> listOrgs(@QueryParam(value="search") String search, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="q") String searchQuery) {
        Map<String, String> searchAttributes;
        firstResult = firstResult != null ? firstResult : 0;
        maxResults = maxResults != null && maxResults <= 100 ? maxResults : 100;
        log.debugf("listOrgs realm: %s, search: %s, query: %s, first: %d, max: %d", new Object[]{this.realm.getName(), search, searchQuery, firstResult, maxResults});
        Map map = searchAttributes = searchQuery == null ? Maps.newHashMap() : SearchQueryUtils.getFields((String)searchQuery);
        if (search != null) {
            searchAttributes.put("name", search.trim());
        }
        return this.orgs.searchForOrganizationStream(this.realm, searchAttributes, firstResult, maxResults, ((OrganizationAdminAuth)this.auth).hasViewOrgs() ? Optional.empty() : Optional.of(((OrganizationAdminAuth)this.auth).getUser())).filter(m -> ((OrganizationAdminAuth)this.auth).hasViewOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgViewOrg((OrganizationModel)m)).map(m -> Converters.convertOrganizationModelToOrganization(m));
    }

    @GET
    @Path(value="count")
    @Produces(value={"application/json"})
    public Long countOrgs(@QueryParam(value="search") String searchQuery) {
        log.debugf("countOrgs %s %s", (Object)this.realm.getName(), (Object)searchQuery);
        if (!((OrganizationAdminAuth)this.auth).hasViewOrgs()) {
            throw new NotAuthorizedException((Object)"Insufficient permission to count organizations.", new Object[0]);
        }
        return this.orgs.getOrganizationsCount(this.realm, searchQuery);
    }

    @POST
    @Path(value="")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createOrg(@Valid Organization body) {
        log.debugf("Create org for %s", (Object)this.realm.getName());
        if (!(((OrganizationAdminAuth)this.auth).hasCreateOrg() || ((OrganizationAdminAuth)this.auth).hasViewOrgs() && ((OrganizationAdminAuth)this.auth).hasManageOrgs())) {
            throw new NotAuthorizedException((Object)"Insufficient permission to create organization.", new Object[0]);
        }
        OrganizationModel org = this.orgs.createOrganization(this.realm, body.getName(), ((OrganizationAdminAuth)this.auth).getUser(), ((OrganizationAdminAuth)this.auth).hasCreateOrg());
        org.setDisplayName(body.getDisplayName());
        org.setUrl(body.getUrl());
        if (body.getAttributes() != null) {
            body.getAttributes().forEach((k, v) -> org.setAttribute((String)k, (List<String>)v));
        }
        if (body.getDomains() != null) {
            org.setDomains(body.getDomains());
        }
        Organization o = Converters.convertOrganizationModelToOrganization(org);
        this.adminEvent.resource(OrganizationResourceType.ORGANIZATION.name()).operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), o.getId()).representation((Object)o).success();
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(o.getId()).build(new Object[0])).build();
    }

    @PUT
    @Path(value="config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addOrganizationsConfig(@Valid OrganizationsConfig body) {
        log.debugf("Create org config for realm %s", (Object)this.realm.getName());
        if (!((OrganizationAdminAuth)this.auth).hasManageRealm()) {
            throw new NotAuthorizedException((Object)"Insufficient permission to update organization config.", new Object[0]);
        }
        this.resetIdentityProviders(body.isSharedIdps());
        this.realm.setAttribute("_providerConfig.orgs.config.createAdminUser", Boolean.valueOf(body.isCreateAdminUser()));
        this.realm.setAttribute("_providerConfig.orgs.config.sharedIdps", Boolean.valueOf(body.isSharedIdps()));
        return Response.ok((Object)body).build();
    }

    private void resetIdentityProviders(boolean newSharedIdpConfig) {
        Boolean existingSharedIdpConfig = this.realm.getAttribute("_providerConfig.orgs.config.sharedIdps", Boolean.valueOf(false));
        if (existingSharedIdpConfig.booleanValue() && !newSharedIdpConfig) {
            this.realm.getIdentityProvidersStream().forEach(identityProviderModel -> {
                identityProviderModel.getConfig().put("home.idp.discovery.shared", "false");
                identityProviderModel.getConfig().put("home.idp.discovery.org", null);
                this.realm.updateIdentityProvider(identityProviderModel);
            });
        }
    }

    @GET
    @Path(value="config")
    @Produces(value={"application/json"})
    public Response getOrganizationConfig() {
        log.debugf("Create org config for realm %s", (Object)this.realm.getName());
        if (!((OrganizationAdminAuth)this.auth).hasManageRealm()) {
            throw new NotAuthorizedException((Object)"Insufficient permission to update organization config.", new Object[0]);
        }
        OrganizationsConfig representation = new OrganizationsConfig();
        representation.setCreateAdminUser(this.realm.getAttribute("_providerConfig.orgs.config.createAdminUser", Boolean.valueOf(true)));
        representation.setSharedIdps(this.realm.getAttribute("_providerConfig.orgs.config.sharedIdps", Boolean.valueOf(false)));
        return Response.ok((Object)representation).build();
    }

    @GET
    @Path(value="export")
    @Produces(value={"application/json"})
    public Response exportOrgs(@QueryParam(value="exportMembersAndInvitations") Boolean exportMembersAndInvitations) {
        boolean membersAndInvitationsExported;
        log.debugf("Export org for %s", (Object)this.realm.getName());
        boolean bl = membersAndInvitationsExported = exportMembersAndInvitations != null && exportMembersAndInvitations != false;
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs()) {
            throw new NotAuthorizedException((Object)"Insufficient permission to export organization.", new Object[0]);
        }
        List<OrganizationRepresentation> organizations = this.orgs.searchForOrganizationStream(this.realm, Map.of(), 0, Integer.MAX_VALUE, Optional.empty()).map(organization -> KeycloakOrgsExportConverter.convertOrganizationModelToOrganizationRepresentation(organization, membersAndInvitationsExported)).toList();
        KeycloakOrgsRepresentation keycloakOrgsRepresentation = new KeycloakOrgsRepresentation();
        keycloakOrgsRepresentation.setOrganizations(organizations);
        Response.ResponseBuilder response = Response.ok();
        response.type("application/json");
        response.entity((Object)keycloakOrgsRepresentation);
        return response.build();
    }

    @POST
    @Path(value="import")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response importOrgs(KeycloakOrgsRepresentation keycloakOrgsRealmRepresentation, @QueryParam(value="skipMissingMember") Boolean skipMissingMember, @QueryParam(value="skipMissingIdp") Boolean skipMissingIdp) {
        boolean missingIdpSkip;
        log.debugf("Import orgs for %s", (Object)this.realm.getName());
        boolean missingMemberSkip = skipMissingMember != null && skipMissingMember != false;
        boolean bl = missingIdpSkip = skipMissingIdp != null && skipMissingIdp != false;
        if (!((OrganizationAdminAuth)this.auth).hasViewOrgs() || !((OrganizationAdminAuth)this.auth).hasManageOrgs()) {
            throw new NotAuthorizedException((Object)"Insufficient permission to import organization.", new Object[0]);
        }
        List<OrganizationRepresentation> organizations = keycloakOrgsRealmRepresentation.getOrganizations();
        if (CollectionUtil.isEmpty(organizations)) {
            Response.ResponseBuilder response = Response.noContent();
            response.type("application/json");
            return response.build();
        }
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), session -> {
            organizations.forEach(organizationRepresentation -> this.createOrganization(missingMemberSkip, missingIdpSkip, session, (OrganizationRepresentation)organizationRepresentation));
            AdminEventBuilder adminEventClone = this.adminEvent.clone(session);
            adminEventClone.resource(OrganizationResourceType.ORGANIZATION_IMPORT.name()).operation(OperationType.CREATE).resourcePath((UriInfo)session.getContext().getUri()).representation((Object)keycloakOrgsRealmRepresentation).success();
        });
        Response.ResponseBuilder response = Response.ok();
        response.type("application/json");
        return response.build();
    }

    private void createOrganization(boolean skipMissingMember, boolean skipMissingIdp, KeycloakSession session, OrganizationRepresentation organizationRepresentation) {
        try {
            OrganizationModel org = ((OrganizationProvider)session.getProvider(OrganizationProvider.class)).createOrganization(this.realm, organizationRepresentation.getOrganization().getName(), this.user, false);
            KeycloakOrgsImportConverter.setOrganizationAttributes(organizationRepresentation.getOrganization(), org);
            KeycloakOrgsImportConverter.createOrganizationRoles(organizationRepresentation.getRoles(), org);
            KeycloakOrgsImportConverter.createOrganizationIdp(this.realm, organizationRepresentation.getIdpLink(), org, skipMissingIdp);
            KeycloakOrgsImportConverter.addMembers(session, this.realm, organizationRepresentation, org, skipMissingMember);
            KeycloakOrgsImportConverter.addInvitations(session, this.realm, organizationRepresentation, org, skipMissingMember);
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists((String)"Duplicate organization with name: %s".formatted(organizationRepresentation.getOrganization().getName()));
        }
        catch (ModelException e) {
            throw ErrorResponse.error((String)e.getMessage(), (Response.Status)Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            throw ErrorResponse.error((String)e.getMessage(), (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

