/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.representation.OrganizationRole;
import io.phasetwo.service.resource.Converters;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.resource.OrganizationResourceType;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class RoleResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(RoleResource.class);
    private final OrganizationModel organization;
    private final OrganizationRoleModel role;
    private final String name;
    private Consumer<String> deleteOrganizationRole;

    public RoleResource(OrganizationAdminResource parent, OrganizationModel organization, String name, Consumer<String> deleteOrganizationRole) {
        super(parent);
        this.organization = organization;
        this.role = organization.getRoleByName(name);
        this.name = name;
        this.deleteOrganizationRole = deleteOrganizationRole;
    }

    @GET
    @Produces(value={"application/json"})
    public OrganizationRole getRole() {
        return Converters.convertOrganizationRole(this.role);
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateRole(OrganizationRole representation) {
        this.canManage();
        if (!Objects.equals(this.role.getDescription(), representation.getDescription())) {
            this.role.setDescription(representation.getDescription());
            OrganizationRole or = Converters.convertOrganizationRole(this.role);
            this.adminEvent.resource(OrganizationResourceType.ORGANIZATION_ROLE.name()).operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri(), or.getName()).representation((Object)or).success();
        }
        return Response.noContent().build();
    }

    @DELETE
    public Response deleteRole() {
        this.canManage();
        this.deleteOrganizationRole.accept(this.name);
        return Response.noContent().build();
    }

    @GET
    @Path(value="users")
    @Produces(value={"application/json"})
    public Stream<UserRepresentation> users() {
        return this.role.getUserMappingsStream().map(m -> ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)m));
    }

    @GET
    @Path(value="users/{userId}")
    @Produces(value={"application/json"})
    public Response userHasRole(@PathParam(value="userId") String userId) {
        UserModel user = this.session.users().getUserById(this.realm, userId);
        if (user != null && this.role.hasRole(user)) {
            return Response.noContent().build();
        }
        throw new NotFoundException(String.format("User %s doesn't have role %s", userId, this.name));
    }

    @PUT
    @Path(value="users/{userId}")
    @Produces(value={"application/json"})
    public Response grantUserRole(@PathParam(value="userId") String userId) {
        this.canManage();
        UserModel user = this.session.users().getUserById(this.realm, userId);
        if (user != null) {
            if (!this.organization.hasMembership(user)) {
                throw new BadRequestException(String.format("User %s must be a member of %s to be granted role.", userId, this.organization.getName()));
            }
            if (!this.role.hasRole(user)) {
                this.role.grantRole(user);
                this.adminEvent.resource(OrganizationResourceType.ORGANIZATION_ROLE_MAPPING.name()).operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation((Object)userId).success();
            }
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().build(new Object[0])).build();
        }
        throw new NotFoundException(String.format("User %s doesn't exist", userId));
    }

    @DELETE
    @Path(value="users/{userId}")
    @Produces(value={"application/json"})
    public Response revokeUserRole(@PathParam(value="userId") String userId) {
        this.canManage();
        UserModel user = this.session.users().getUserById(this.realm, userId);
        if (user != null && this.role.hasRole(user)) {
            this.role.revokeRole(user);
            this.adminEvent.resource(OrganizationResourceType.ORGANIZATION_ROLE_MAPPING.name()).operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation((Object)userId).success();
            return Response.noContent().build();
        }
        throw new NotFoundException(String.format("User %s doesn't have role %s", userId, this.name));
    }

    private void canManage() {
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs() && !((OrganizationAdminAuth)this.auth).hasOrgManageRoles(this.organization)) {
            throw new NotAuthorizedException((Object)String.format("User %s doesn't have permission to manage roles in org %s", ((OrganizationAdminAuth)this.auth).getUser().getId(), this.organization.getName()), new Object[0]);
        }
    }
}

