/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.representation.BulkResponseItem;
import io.phasetwo.service.representation.OrganizationRole;
import io.phasetwo.service.resource.Converters;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.resource.OrganizationResourceType;
import io.phasetwo.service.resource.RoleResource;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.events.admin.OperationType;

public class RolesResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(RolesResource.class);
    private final OrganizationModel organization;

    public RolesResource(OrganizationAdminResource parent, OrganizationModel organization) {
        super(parent);
        this.organization = organization;
    }

    @Path(value="{alias}")
    public RoleResource roles(@PathParam(value="alias") String name) {
        if (this.organization.getRoleByName(name) == null) {
            throw new NotFoundException();
        }
        return new RoleResource(this, this.organization, name, this::deleteOrganizationRole);
    }

    @GET
    @Produces(value={"application/json"})
    public Stream<OrganizationRole> getRoles() {
        return this.organization.getRolesStream().map(r -> Converters.convertOrganizationRole(r));
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createRole(OrganizationRole representation) {
        this.canManage();
        OrganizationRole or = this.createOrganizationRole(representation);
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(or.getName()).build(new Object[0])).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createRoles(List<OrganizationRole> representation) {
        this.canManage();
        ArrayList responseItems = new ArrayList();
        representation.forEach(role -> {
            BulkResponseItem item = new BulkResponseItem().status(Response.Status.CREATED.getStatusCode());
            try {
                item.setItem(this.createOrganizationRole((OrganizationRole)role));
            }
            catch (Exception ex) {
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setError(ex.getMessage());
            }
            responseItems.add(item);
        });
        return Response.status((int)207).location(this.session.getContext().getUri().getAbsolutePathBuilder().build(new Object[0])).entity(responseItems).build();
    }

    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteRoles(List<OrganizationRole> representation) {
        this.canManage();
        ArrayList responseItems = new ArrayList();
        representation.forEach(role -> {
            BulkResponseItem item = new BulkResponseItem().status(Response.Status.NO_CONTENT.getStatusCode());
            try {
                this.deleteOrganizationRole(role.getName());
                item.setItem(role);
            }
            catch (Exception ex) {
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setError(ex.getMessage());
            }
            responseItems.add(item);
        });
        return Response.status((int)207).location(this.session.getContext().getUri().getAbsolutePathBuilder().build(new Object[0])).entity(responseItems).build();
    }

    private OrganizationRole createOrganizationRole(OrganizationRole representation) {
        OrganizationRoleModel r = this.organization.getRoleByName(representation.getName());
        if (r != null) {
            log.debug((Object)"duplicate role");
            throw new ClientErrorException(Response.Status.CONFLICT);
        }
        r = this.organization.addRole(representation.getName());
        r.setDescription(representation.getDescription());
        OrganizationRole or = Converters.convertOrganizationRole(r);
        this.adminEvent.resource(OrganizationResourceType.ORGANIZATION_ROLE.name()).operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), or.getName()).representation((Object)or).success();
        return or;
    }

    public void deleteOrganizationRole(String roleName) {
        if (Arrays.asList(OrganizationAdminAuth.DEFAULT_ORG_ROLES).contains(roleName)) {
            throw new BadRequestException(String.format("Default organization role %s cannot be deleted.", roleName));
        }
        this.organization.removeRole(roleName);
        this.adminEvent.resource(OrganizationResourceType.ORGANIZATION_ROLE.name()).operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri(), roleName).representation((Object)roleName).success();
    }

    private void canManage() {
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs() && !((OrganizationAdminAuth)this.auth).hasOrgManageRoles(this.organization)) {
            throw new NotAuthorizedException((Object)String.format("User %s doesn't have permission to manage roles in org %s", ((OrganizationAdminAuth)this.auth).getUser().getId(), this.organization.getName()), new Object[0]);
        }
    }
}

