/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.representation.BulkResponseItem;
import io.phasetwo.service.representation.Organization;
import io.phasetwo.service.representation.OrganizationRole;
import io.phasetwo.service.representation.SwitchOrganization;
import io.phasetwo.service.resource.Converters;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.resource.OrganizationAdminResource;
import io.phasetwo.service.resource.OrganizationResourceType;
import io.phasetwo.service.util.ActiveOrganization;
import io.phasetwo.service.util.TokenManager;
import jakarta.validation.Valid;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;

public class UserResource
extends OrganizationAdminResource {
    private static final Logger log = Logger.getLogger(UserResource.class);

    public UserResource(KeycloakSession session) {
        super(session);
    }

    @GET
    @Path(value="/{userId}/orgs")
    @Produces(value={"application/json"})
    public Stream<Organization> listUserOrgs(@PathParam(value="userId") String userId) {
        log.debugv("Get org memberships for %s %s", (Object)this.realm.getName(), (Object)userId);
        UserModel user = this.session.users().getUserById(this.realm, userId);
        return this.orgs.getUserOrganizationsStream(this.realm, user).filter(m -> ((OrganizationAdminAuth)this.auth).hasViewOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgViewOrg((OrganizationModel)m)).map(m -> Converters.convertOrganizationModelToOrganization(m));
    }

    @GET
    @Path(value="/{userId}/orgs/{orgId}/roles")
    @Produces(value={"application/json"})
    public Stream<OrganizationRole> listUserOrgRoles(@PathParam(value="userId") String userId, @PathParam(value="orgId") String orgId) {
        log.debugv("Get org roles for %s %s %s", (Object)this.realm.getName(), (Object)userId, (Object)orgId);
        UserModel user = this.session.users().getUserById(this.realm, userId);
        OrganizationModel org = this.orgs.getOrganizationById(this.realm, orgId);
        if (((OrganizationAdminAuth)this.auth).hasViewOrgs() || ((OrganizationAdminAuth)this.auth).hasOrgViewRoles(org)) {
            if (org.hasMembership(user)) {
                return org.getRolesStream().filter(r -> r.hasRole(user)).map(r -> Converters.convertOrganizationRole(r));
            }
            throw new NotFoundException("User is not a member of the organization");
        }
        throw new NotAuthorizedException((Object)"Insufficient permissions", new Object[0]);
    }

    @PUT
    @Path(value="/switch-organization")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response switchActiveOrganization(@Valid SwitchOrganization body) {
        OrganizationModel organization = this.orgs.getOrganizationById(this.realm, body.getId());
        if (organization == null) {
            throw new NotFoundException(String.format("%s not found", body.getId()));
        }
        if (!organization.hasMembership(this.user)) {
            throw new NotAuthorizedException((Object)"Not a member of this organization.", new Object[0]);
        }
        String currentActiveOrganization = this.user.getFirstAttribute("org.ro.active");
        this.user.setAttribute("org.ro.active", Collections.singletonList(body.getId()));
        TokenManager tokenManager = new TokenManager(this.session, ((OrganizationAdminAuth)this.auth).getToken(), this.realm, this.user);
        EventBuilder event = new EventBuilder(this.realm, this.session, this.connection);
        event.event(EventType.UPDATE_PROFILE).user(this.user).detail("new_active_organization_id", body.getId()).detail("previous_active_organization_id", currentActiveOrganization).success();
        return Response.ok((Object)tokenManager.generateTokens()).build();
    }

    @GET
    @Path(value="/active-organization")
    @Produces(value={"application/json"})
    public Organization getActiveOrganization() {
        ActiveOrganization activeOrganizationUtil = ActiveOrganization.fromContext(this.session, this.realm, ((OrganizationAdminAuth)this.auth).getUser());
        if (!activeOrganizationUtil.isValid()) {
            throw new NotAuthorizedException((Object)"Action not allowed.", new Object[0]);
        }
        return Converters.convertOrganizationModelToOrganization(activeOrganizationUtil.getOrganization());
    }

    @PUT
    @Path(value="/{userId}/orgs/{orgId}/roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response grantUserOrgRoles(@PathParam(value="userId") String userId, @PathParam(value="orgId") String orgId, List<OrganizationRole> rolesRep) {
        log.debugf("Grant user organization roles for %s %s %s", (Object)this.realm.getName(), (Object)userId, (Object)orgId);
        UserModel user = this.session.users().getUserById(this.realm, userId);
        OrganizationModel org = this.orgs.getOrganizationById(this.realm, orgId);
        this.canManage(userId, orgId, user, org);
        ArrayList responseItems = new ArrayList();
        rolesRep.forEach(roleRep -> {
            BulkResponseItem item = new BulkResponseItem().status(Response.Status.CREATED.getStatusCode());
            try {
                OrganizationRoleModel role = org.getRoleByName(roleRep.getName());
                if (role == null) {
                    throw new NotFoundException(String.format("Organization %s doesn't contain role %s", orgId, roleRep.getName()));
                }
                if (!role.hasRole(user)) {
                    role.grantRole(user);
                    this.adminEvent.resource(OrganizationResourceType.ORGANIZATION_ROLE_MAPPING.name()).operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation((Object)userId).success();
                }
                item.setItem(Converters.convertOrganizationRole(role));
            }
            catch (Exception ex) {
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setError(ex.getMessage());
            }
            responseItems.add(item);
        });
        return Response.status((int)207).location(this.session.getContext().getUri().getAbsolutePathBuilder().build(new Object[0])).entity(responseItems).build();
    }

    @PATCH
    @Path(value="/{userId}/orgs/{orgId}/roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response revokeUserOrgRoles(@PathParam(value="userId") String userId, @PathParam(value="orgId") String orgId, List<OrganizationRole> rolesRep) {
        log.debugf("Revoke user organization roles for %s %s %s", (Object)this.realm.getName(), (Object)userId, (Object)orgId);
        UserModel user = this.session.users().getUserById(this.realm, userId);
        OrganizationModel org = this.orgs.getOrganizationById(this.realm, orgId);
        this.canManage(userId, orgId, user, org);
        ArrayList responseItems = new ArrayList();
        rolesRep.forEach(roleRep -> {
            BulkResponseItem item = new BulkResponseItem().status(Response.Status.NO_CONTENT.getStatusCode());
            OrganizationRoleModel role = org.getRoleByName(roleRep.getName());
            try {
                if (role == null) {
                    throw new NotFoundException(String.format("Organization %s doesn't contain role %s", orgId, roleRep.getName()));
                }
                if (role.hasRole(user)) {
                    role.revokeRole(user);
                    this.adminEvent.resource(OrganizationResourceType.ORGANIZATION_ROLE_MAPPING.name()).operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation((Object)userId).success();
                }
                item.setItem(Converters.convertOrganizationRole(role));
            }
            catch (Exception ex) {
                item.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
                item.setError(ex.getMessage());
            }
            responseItems.add(item);
        });
        return Response.status((int)207).location(this.session.getContext().getUri().getAbsolutePathBuilder().build(new Object[0])).entity(responseItems).build();
    }

    private void canManage(String userId, String orgId, UserModel user, OrganizationModel org) {
        if (user == null) {
            throw new NotFoundException(String.format("User %s doesn't exist", userId));
        }
        if (org == null) {
            throw new NotFoundException(String.format("Organization %s doesn't exist", orgId));
        }
        if (!org.hasMembership(user)) {
            throw new BadRequestException(String.format("User %s must be a member of %s to be granted roles.", userId, org.getName()));
        }
        if (!((OrganizationAdminAuth)this.auth).hasManageOrgs() && !((OrganizationAdminAuth)this.auth).hasOrgManageRoles(org)) {
            throw new NotAuthorizedException((Object)"Insufficient permissions", new Object[0]);
        }
    }
}

