/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.resource;

import com.google.auto.service.AutoService;
import io.phasetwo.service.Orgs;
import io.phasetwo.service.resource.UserResourceProvider;
import java.util.HashSet;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.representations.userprofile.config.UPAttribute;
import org.keycloak.representations.userprofile.config.UPAttributePermissions;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;
import org.keycloak.userprofile.UserProfileProvider;

@AutoService(value={RealmResourceProviderFactory.class})
public class UserResourceProviderFactory
implements RealmResourceProviderFactory {
    private static final Logger log = Logger.getLogger(UserResourceProviderFactory.class);
    static final String ID = "users";

    public RealmResourceProvider create(KeycloakSession session) {
        log.debug((Object)"UserResourceProviderFactory::create");
        return new UserResourceProvider(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        log.debug((Object)"UserResourceProviderFactory::postInit");
        factory.register(event -> {
            if (event instanceof RealmModel.RealmPostCreateEvent) {
                log.debug((Object)"RealmPostCreateEvent");
                this.realmPostCreateInitUserProfile((RealmModel.RealmPostCreateEvent)event);
            } else if (event instanceof PostMigrationEvent) {
                log.debug((Object)"PostMigrationEvent");
                if (Orgs.KC_ORGS_SKIP_MIGRATION == null) {
                    log.info((Object)"initializing active organization user profile attribute following migration");
                    KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, this::postMigrationInitUserProfile);
                }
            }
        });
    }

    private void realmPostCreateInitUserProfile(RealmModel.RealmPostCreateEvent event) {
        log.debug((Object)"UserResourceProviderFactory::realmPostCreateInitUserProfile");
        KeycloakSession session = event.getKeycloakSession();
        session.getContext().setRealm(event.getCreatedRealm());
        this.initUserProfile(session);
    }

    private void postMigrationInitUserProfile(KeycloakSession session) {
        log.debug((Object)"UserResourceProviderFactory::postMigrationInitUserProfile");
        session.realms().getRealmsStream().forEach(realm -> {
            session.getContext().setRealm(realm);
            this.initUserProfile(session);
        });
    }

    private void initUserProfile(KeycloakSession session) {
        log.debug((Object)"UserResourceProviderFactory::initUserProfile");
        UPConfig config = ((UserProfileProvider)session.getProvider(UserProfileProvider.class)).getConfiguration();
        this.addActiveOrganizationAttribute(config);
        UserProfileProvider t = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        try {
            t.setConfiguration(config);
        }
        catch (ComponentValidationException e) {
            log.error((Object)e.getMessage());
        }
    }

    private void addActiveOrganizationAttribute(UPConfig config) {
        if (config.getAttribute("org.ro.active") != null) {
            return;
        }
        UPAttribute activeOrgAttribute = new UPAttribute();
        activeOrgAttribute.setName("org.ro.active");
        activeOrgAttribute.setDisplayName("Active organization ID");
        UPAttributePermissions permissions = new UPAttributePermissions();
        permissions.setEdit(new HashSet<String>(List.of("admin")));
        permissions.setView(new HashSet<String>(List.of("admin")));
        activeOrgAttribute.setPermissions(permissions);
        activeOrgAttribute.setMultivalued(false);
        config.getAttributes().add(activeOrgAttribute);
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

