/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.util;

import com.google.common.collect.Lists;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class ActiveOrganization {
    private static final Logger log = Logger.getLogger(ActiveOrganization.class);
    private final RealmModel realm;
    private final UserModel user;
    private final OrganizationProvider organizationProvider;
    private final OrganizationModel organization;

    public static ActiveOrganization fromContext(KeycloakSession session, RealmModel realm, UserModel user) {
        return new ActiveOrganization(session, realm, user);
    }

    private ActiveOrganization(KeycloakSession session, RealmModel realm, UserModel user) {
        this.realm = realm;
        this.user = user;
        this.organizationProvider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        this.organization = this.userHasActiveOrganizationAttribute() ? this.initializeActiveOrganization() : this.initializeDefaultActiveOrganization();
        this.clearOutdatedActiveOrganizationAttribute();
    }

    private boolean userHasActiveOrganizationAttribute() {
        return this.user.getAttributes().containsKey("org.ro.active");
    }

    private OrganizationModel initializeActiveOrganization() {
        return this.organizationProvider.getOrganizationById(this.realm, this.getActiveOrganizationIdFromAttribute());
    }

    private OrganizationModel initializeDefaultActiveOrganization() {
        Stream<OrganizationModel> userOrganizations = this.organizationProvider.getUserOrganizationsStream(this.realm, this.user);
        return userOrganizations.findFirst().orElse(null);
    }

    private void clearOutdatedActiveOrganizationAttribute() {
        if (!this.userHasOrganization() && this.userHasActiveOrganizationAttribute()) {
            this.user.setAttribute("org.ro.active", new ArrayList());
        } else if (this.organizationProvider.getUserOrganizationsStream(this.realm, this.user).noneMatch(org -> org.getId().equals(this.getActiveOrganizationIdFromAttribute()))) {
            log.warnf("%s doesn't belong to this organization", (Object)this.user.getUsername());
            this.user.setAttribute("org.ro.active", new ArrayList());
        }
    }

    public boolean userHasOrganization() {
        return this.organizationProvider.getUserOrganizationsStream(this.realm, this.user).findFirst().isPresent();
    }

    private String getActiveOrganizationIdFromAttribute() {
        return this.user.getFirstAttribute("org.ro.active");
    }

    public List<String> getUserActiveOrganizationRoles() {
        ArrayList userOrganizationRoles = Lists.newArrayList();
        this.organization.getRolesStream().forEach(role -> {
            if (role.hasRole(this.user)) {
                userOrganizationRoles.add(role.getName());
            }
        });
        return userOrganizationRoles;
    }

    public boolean isCurrentActiveOrganization(String organizationId) {
        return this.organization.getId().equals(organizationId);
    }

    public boolean isValid() {
        return this.organization != null;
    }

    public OrganizationModel getOrganization() {
        return this.organization;
    }
}

