/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.util;

import java.util.Optional;
import java.util.Set;

public final class Domains {
    public static Optional<String> extract(String usernameOrEmail) {
        String strDomain;
        int atIndex;
        if (usernameOrEmail != null && (atIndex = usernameOrEmail.trim().lastIndexOf("@")) >= 0 && !(strDomain = usernameOrEmail.trim().substring(atIndex + 1)).isEmpty()) {
            return Optional.of(strDomain);
        }
        return Optional.empty();
    }

    public static boolean supportsDomain(Set<String> orgDomains, String userEmailDomain) {
        return orgDomains.stream().anyMatch(it -> it.equals(userEmailDomain) || Domains.isSubDomainOf(userEmailDomain, it));
    }

    private static boolean isSubDomainOf(String subdomain, String orgDomain) {
        return subdomain.endsWith("." + orgDomain);
    }
}

