/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.util;

import com.google.common.base.Strings;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.email.freemarker.beans.ProfileBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class Emails {
    public static void sendEmail(String templateName, String subjectKey, List<Object> subjectAttributes, Map<String, Object> bodyAttributes, KeycloakSession session, RealmModel realm, UserModel user) throws EmailException {
        EmailTemplateProvider emailTemplateProvider = (EmailTemplateProvider)session.getProvider(EmailTemplateProvider.class);
        String realmName = Strings.isNullOrEmpty((String)realm.getDisplayName()) ? realm.getName() : realm.getDisplayName();
        bodyAttributes.put("realmName", realmName);
        bodyAttributes.put("user", new ProfileBean(user, session));
        emailTemplateProvider.setRealm(realm).setUser(user).setAttribute("realmName", (Object)realmName).send(subjectKey, subjectAttributes, templateName, bodyAttributes);
    }

    public static InternetAddress getValidEmail(String email) throws AddressException {
        Objects.requireNonNull(email, "email must not be null to validate");
        if (email.startsWith("mailto:")) {
            email = email.substring(7);
        }
        InternetAddress emailAddr = new InternetAddress(email);
        emailAddr.validate();
        return emailAddr;
    }

    public static boolean isValidEmail(String email) {
        try {
            Emails.getValidEmail(email);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

