/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.util;

import io.phasetwo.service.model.OrganizationModel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.Constants;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.representations.idm.IdentityProviderRepresentation;

public final class IdentityProviders {
    private IdentityProviders() {
    }

    public static Set<String> getAttributeMultivalued(Map<String, String> config, String attrKey) {
        if (config == null) {
            return new HashSet<String>();
        }
        String attrValue = config.get(attrKey);
        if (attrValue == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(Arrays.asList(Constants.CFG_DELIMITER_PATTERN.split(attrValue)));
    }

    public static void setAttributeMultivalued(Map<String, String> config, String attrKey, Set<String> attrValues) {
        if (config == null) {
            return;
        }
        if (attrValues == null || attrValues.size() == 0) {
            config.put(attrKey, null);
        } else {
            String attrValueFull = String.join((CharSequence)"##", attrValues);
            config.put(attrKey, attrValueFull);
        }
    }

    public static void removeOrganization(String orgId, IdentityProviderModel idp) {
        Set<String> orgs = IdentityProviders.getAttributeMultivalued(idp.getConfig(), "home.idp.discovery.org");
        orgs.remove(orgId);
        IdentityProviders.setAttributeMultivalued(idp.getConfig(), "home.idp.discovery.org", orgs);
        if (orgs.size() > 1) {
            idp.getConfig().put("home.idp.discovery.shared", "true");
        } else {
            idp.getConfig().put("home.idp.discovery.shared", "false");
        }
    }

    public static void addMultiOrganization(OrganizationModel organization, IdentityProviderRepresentation representation) {
        Set<String> orgs = IdentityProviders.getAttributeMultivalued(representation.getConfig(), "home.idp.discovery.org");
        orgs.add(organization.getId());
        IdentityProviders.setAttributeMultivalued(representation.getConfig(), "home.idp.discovery.org", orgs);
        if (orgs.size() > 1) {
            representation.getConfig().put("home.idp.discovery.shared", "true");
        } else {
            representation.getConfig().put("home.idp.discovery.shared", "false");
        }
    }
}

