/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.util;

import jakarta.ws.rs.NotFoundException;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.util.MtlsHoKTokenUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

public class TokenManager {
    private final KeycloakSession session;
    private final AccessToken accessToken;
    private final RealmModel realm;
    private final ClientModel targetClient;
    private final OIDCAdvancedConfigWrapper targetClientConfig;
    private final UserModel user;

    public TokenManager(KeycloakSession session, AccessToken accessToken, RealmModel realm, UserModel user) {
        this.accessToken = accessToken;
        this.realm = realm;
        this.targetClient = ((ClientProvider)session.getProvider(ClientProvider.class)).getClientByClientId(realm, accessToken.getIssuedFor());
        this.targetClientConfig = OIDCAdvancedConfigWrapper.fromClientModel((ClientModel)this.targetClient);
        this.user = user;
        this.session = session;
        this.session.getContext().setClient(this.targetClient);
    }

    public AccessTokenResponse generateTokens() {
        String scopeParam;
        AuthenticationSessionModel authSession = this.getAuthSession(this.getScopeIds());
        EventBuilder event = new EventBuilder(this.session.getContext().getRealm(), this.session, this.session.getContext().getConnection());
        ClientSessionContext clientSessionCtx = AuthenticationProcessor.attachSession((AuthenticationSessionModel)authSession, null, (KeycloakSession)this.session, (RealmModel)this.realm, (ClientConnection)this.session.getContext().getConnection(), (EventBuilder)event);
        UserSessionModel userSession = clientSessionCtx.getClientSession().getUserSession();
        org.keycloak.protocol.oidc.TokenManager tokenManager = new org.keycloak.protocol.oidc.TokenManager();
        TokenManager.AccessTokenResponseBuilder responseBuilder = tokenManager.responseBuilder(this.realm, this.targetClient, event, this.session, userSession, clientSessionCtx).generateAccessToken();
        responseBuilder.getAccessToken().audience(this.accessToken.getAudience());
        responseBuilder.getAccessToken().setAllowedOrigins(this.accessToken.getAllowedOrigins());
        boolean useRefreshToken = this.targetClientConfig.isUseRefreshToken();
        if (useRefreshToken) {
            responseBuilder.generateRefreshToken();
        }
        if (TokenUtil.isOIDCRequest((String)(scopeParam = clientSessionCtx.getClientSession().getNote("scope")))) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        this.checkAndBindMtlsHoKToken(event, responseBuilder, useRefreshToken);
        return responseBuilder.build();
    }

    private void checkAndBindMtlsHoKToken(EventBuilder event, TokenManager.AccessTokenResponseBuilder responseBuilder, boolean useRefreshToken) {
        if (this.targetClientConfig.isUseMtlsHokToken()) {
            AccessToken.Confirmation confirmation = MtlsHoKTokenUtil.bindTokenWithClientCertificate((HttpRequest)this.session.getContext().getHttpRequest(), (KeycloakSession)this.session);
            if (confirmation != null) {
                responseBuilder.getAccessToken().setConfirmation(confirmation);
                if (useRefreshToken) {
                    responseBuilder.getRefreshToken().setConfirmation(confirmation);
                }
            } else {
                event.error("invalid_request");
                throw new NotFoundException("Client Certification missing for MTLS HoK Token Binding");
            }
        }
    }

    private Set<String> getScopeIds() {
        Map defaultClientScopes = this.targetClient.getClientScopes(true);
        Map optionalClientScopes = this.targetClient.getClientScopes(false);
        Set<String> clientScopeIds = defaultClientScopes.values().stream().map(ClientScopeModel::getId).collect(Collectors.toSet());
        Set<String> accessTokenScopes = Set.of(this.accessToken.getScope().split(" "));
        optionalClientScopes.values().stream().filter(cs -> accessTokenScopes.contains(cs.getName())).map(ClientScopeModel::getId).forEach(clientScopeIds::add);
        return clientScopeIds;
    }

    private AuthenticationSessionModel getAuthSession(Set<String> clientScopeIds) {
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(this.targetClient);
        authSession.setAuthenticatedUser(this.user);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer((URI)this.session.getContext().getUri().getBaseUri(), (String)this.realm.getName()));
        authSession.setClientNote("scope", this.accessToken.getScope());
        authSession.setClientScopes(clientScopeIds);
        return authSession;
    }
}

