/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import org.jboss.logging.Logger;
import org.keycloak.authorization.common.UserModelIdentity;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;

public class Permissions {
    private static final Logger log = Logger.getLogger(Permissions.class);

    public static AdminPermissionEvaluator evaluator(KeycloakSession session, RealmModel realm, RealmModel adminRealm, UserModel admin) {
        if (log.isTraceEnabled()) {
            log.tracef("realm %s adminRealm %s", (Object)realm.getName(), (Object)adminRealm.getName());
            String clientId = null;
            RealmManager realmManager = new RealmManager(session);
            if (RealmManager.isAdministrationRealm((RealmModel)adminRealm)) {
                log.tracef("isAdministrationRealm %s", (Object)adminRealm.getName());
                clientId = realm.getMasterAdminClient().getClientId();
            } else if (adminRealm.equals((Object)realm)) {
                log.tracef("adminRealm.equals(realm)) %s", (Object)realm.getName());
                clientId = realm.getClientByClientId(realmManager.getRealmAdminClientId(realm)).getClientId();
            }
            log.tracef("permissions clientId %s", clientId);
            ClientModel client = realm.getClientByClientId(clientId);
            log.tracef("permissions clientId model is %s", (Object)client);
        }
        if (RealmManager.isAdministrationRealm((RealmModel)adminRealm) || !adminRealm.equals((Object)realm)) {
            MgmtPermissions perm = new MgmtPermissions(session, realm, adminRealm, admin);
            perm.identity = new UserModelIdentity(adminRealm, admin);
            return perm;
        }
        return AdminPermissions.evaluator((KeycloakSession)session, (RealmModel)realm, (RealmModel)adminRealm, (UserModel)admin);
    }
}

