/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.themes.resource;

import io.phasetwo.keycloak.themes.resource.CorsResource;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.HttpHeaders;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;

public abstract class AbstractAdminResource {
    private static final Logger log = Logger.getLogger(AbstractAdminResource.class);
    protected final ClientConnection connection;
    protected final HttpHeaders headers;
    protected final KeycloakSession session;
    protected final RealmModel realm;
    protected AdminAuth auth;
    protected AdminEventBuilder adminEvent;
    protected AdminPermissionEvaluator permissions;
    protected EventBuilder event;

    protected AbstractAdminResource(KeycloakSession session) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.headers = session.getContext().getRequestHeaders();
        this.connection = session.getContext().getConnection();
    }

    public void setup() {
        this.setupAuth();
        this.setupEvents();
        this.setupPermissions();
        this.setupCors();
    }

    private void setupCors() {
        CorsResource.setupCors(this.session, this.auth);
    }

    private void setupAuth() {
        this.auth = this.authenticateRealmAdminRequest(this.headers);
    }

    private void setupEvents() {
        this.adminEvent = new AdminEventBuilder(this.realm, this.auth, this.session, this.session.getContext().getConnection()).realm(this.realm);
        this.event = new EventBuilder(this.realm, this.session, this.connection).realm(this.realm);
    }

    private void setupPermissions() {
        this.permissions = AdminPermissions.evaluator((KeycloakSession)this.session, (RealmModel)this.realm, (AdminAuth)this.auth);
    }

    private AdminAuth authenticateRealmAdminRequest(HttpHeaders headers) {
        AccessToken token;
        String tokenString = AppAuthManager.extractAuthorizationHeaderToken((HttpHeaders)headers);
        if (tokenString == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        try {
            JWSInput input = new JWSInput(tokenString);
            token = (AccessToken)input.readJsonContent(AccessToken.class);
        }
        catch (JWSInputException e) {
            throw new NotAuthorizedException((Object)"Bearer token format error", new Object[0]);
        }
        String realmName = token.getIssuer().substring(token.getIssuer().lastIndexOf(47) + 1);
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            throw new NotAuthorizedException((Object)"Unknown realm in token", new Object[0]);
        }
        this.session.getContext().setRealm(realm);
        AuthenticationManager.AuthResult authResult = new AppAuthManager.BearerTokenAuthenticator(this.session).setRealm(realm).setConnection(this.connection).setHeaders(headers).authenticate();
        if (authResult == null) {
            log.debug((Object)"Token not valid");
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        ClientModel client = realm.getClientByClientId(token.getIssuedFor());
        if (client == null) {
            throw new NotFoundException("Could not find client for authorization");
        }
        return new AdminAuth(realm, authResult.getToken(), authResult.getUser(), client);
    }
}

