/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.themes.resource;

import com.google.common.base.Strings;
import com.google.common.io.CharSource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.Urls;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.theme.Theme;

public class AssetsResourceProvider
implements RealmResourceProvider {
    private static final Logger log = Logger.getLogger(AssetsResourceProvider.class);
    private KeycloakSession session;
    public static final String ASSETS_LOGIN_PREFIX = "_providerConfig.assets.login";
    public static final String ASSETS_LOGIN_PRIMARY_COLOR = "_providerConfig.assets.login.primaryColor";
    public static final String ASSETS_LOGIN_SECONDARY_COLOR = "_providerConfig.assets.login.secondaryColor";
    public static final String ASSETS_LOGIN_BACKGROUND_COLOR = "_providerConfig.assets.login.backgroundColor";
    public static final String ASSETS_LOGIN_CSS = "_providerConfig.assets.login.css";
    public static final String ASSETS_LOGO_URL = "_providerConfig.assets.logo.url";
    public static final String ASSETS_FAVICON_URL = "_providerConfig.assets.favicon.url";
    public static final String DEFAULT_LOGO_PATH = "img/empty.png";
    public static final String DEFAULT_FAVICON_PATH = "img/default-favicon.ico";

    public AssetsResourceProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    @GET
    @Path(value="img/logo")
    public Response logo(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws IOException {
        return this.resourceRedirect(uriInfo, ASSETS_LOGO_URL, DEFAULT_LOGO_PATH);
    }

    @GET
    @Path(value="img/favicon")
    public Response favicon(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws IOException {
        return this.resourceRedirect(uriInfo, ASSETS_FAVICON_URL, DEFAULT_FAVICON_PATH);
    }

    private Response resourceRedirect(UriInfo uriInfo, String key, String defaultPath) {
        String imgUrl = this.session.getContext().getRealm().getAttribute(key);
        URI redir = null;
        try {
            if (imgUrl == null) {
                Theme theme = this.session.theme().getTheme(Theme.Type.LOGIN);
                URI baseUri = this.session.getContext().getUri().getBaseUri();
                URI themeRoot = new URI(Urls.themeRoot((URI)baseUri).toString() + "/");
                redir = themeRoot.resolve(String.format("%s/%s/%s", theme.getType().toString().toLowerCase(), theme.getName(), defaultPath));
            } else {
                redir = new URI(imgUrl);
            }
            log.infof("redirecting to %s", (Object)redir);
            return Response.seeOther((URI)redir).build();
        }
        catch (Exception e) {
            throw new NotFoundException((Throwable)e);
        }
    }

    private void setColors(StringBuilder o) {
        this.setColor(o, ASSETS_LOGIN_PRIMARY_COLOR, "--pf-v5-global--primary-color--100");
        this.setColor(o, ASSETS_LOGIN_PRIMARY_COLOR, "--pf-v5-global--active-color--100");
        this.setColor(o, ASSETS_LOGIN_PRIMARY_COLOR, "--pf-v5-global--primary-color--dark-100");
        this.setColor(o, ASSETS_LOGIN_PRIMARY_COLOR, "--pf-v5-global--link--Color");
        this.setColor(o, ASSETS_LOGIN_PRIMARY_COLOR, "--pf-v5-global--link--Color--dark");
        this.setColor(o, ASSETS_LOGIN_SECONDARY_COLOR, "--pf-v5-global--primary-color--200");
        this.setColor(o, ASSETS_LOGIN_SECONDARY_COLOR, "--pf-v5-global--link--Color--hover");
        this.setColor(o, ASSETS_LOGIN_SECONDARY_COLOR, "--pf-v5-global--link--Color--dark--hover");
        this.setColor(o, ASSETS_LOGIN_BACKGROUND_COLOR, "--pf-v5-global--BackgroundColor--100");
    }

    private void setColor(StringBuilder o, String key, String name) {
        String v = this.session.getContext().getRealm().getAttribute(key);
        if (v != null) {
            o.append(name).append(": ").append(v).append(";\n");
        }
    }

    @GET
    @Path(value="css/login.css")
    @Produces(value={"text/css"})
    public Response cssLogin(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws IOException {
        String css = this.session.getContext().getRealm().getAttribute(ASSETS_LOGIN_CSS);
        if (Strings.isNullOrEmpty((String)css)) {
            StringBuilder o = new StringBuilder("/* login css */\n");
            o.append(":root {\n");
            this.setColors(o);
            o.append("}\n");
            css = o.toString();
        }
        InputStream resource = CharSource.wrap((CharSequence)css).asByteSource(StandardCharsets.UTF_8).openStream();
        String mimeType = "text/css";
        return null == resource ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok((Object)resource, (String)mimeType).build();
    }

    public void close() {
    }
}

