/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.themes.resource;

import com.google.common.collect.ImmutableMap;
import io.phasetwo.keycloak.themes.resource.AbstractAdminResource;
import io.phasetwo.keycloak.themes.theme.AttributeTheme;
import io.phasetwo.keycloak.themes.theme.MustacheProvider;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.http.FormPartValue;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.theme.Theme;

public class EmailsResource
extends AbstractAdminResource {
    private static final Logger log = Logger.getLogger(EmailsResource.class);
    public static final Map<String, Object> EMAIL_TEMPLATES = new ImmutableMap.Builder().put((Object)"email-verification", (Object)"Verification").put((Object)"event-login_error", (Object)"Login error").put((Object)"event-update_password", (Object)"Update Password").put((Object)"executeActions", (Object)"Execute Required Actions").put((Object)"password-reset", (Object)"Password Reset").put((Object)"email-update-confirmation", (Object)"Update confirmation").put((Object)"email-verification-with-code", (Object)"Verification with code").put((Object)"event-remove_totp", (Object)"Remove OTP").put((Object)"event-update_totp", (Object)"Update OTP").put((Object)"identity-provider-link", (Object)"Link to Identity Provider").put((Object)"magic-link-email", (Object)"Magic link").put((Object)"invitation-email", (Object)"Organization invitation").put((Object)"otp-email", (Object)"OTP Code").put((Object)"magic-link-continuation-email", (Object)"Magic link continuation").build();

    public EmailsResource(KeycloakSession session) {
        super(session);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="templates")
    public Map<String, Object> listEmailTemplates(@Context HttpHeaders headers, @Context UriInfo uriInfo) {
        if (!this.permissions.realm().canViewRealm()) {
            throw new ForbiddenException("Get email templates requires view-realm");
        }
        return EMAIL_TEMPLATES;
    }

    private String getTemplatePath(String templateType, String templateName) {
        return String.format("%s/%s.mustache", templateType, templateName);
    }

    private boolean templateExists(String templateName) {
        return EMAIL_TEMPLATES.get(templateName) != null;
    }

    private Theme getEmailThemeForRealm(KeycloakSession session) throws IOException {
        log.infof("get email theme for realm %s", (Object)this.realm.getName());
        session.setAttribute("attribute-theme-realm", (Object)this.realm.getName());
        return session.theme().getTheme(this.realm.getEmailTheme(), Theme.Type.EMAIL);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="templates/{templateType}/{templateName}")
    public String getEmailTemplate(@PathParam(value="templateType") String templateType, @PathParam(value="templateName") String templateName) {
        if (!this.permissions.realm().canViewRealm()) {
            throw new ForbiddenException("Get email template requires view-realm");
        }
        if (!this.templateExists(templateName)) {
            throw new NotFoundException(templateName + " not found");
        }
        String templatePath = this.getTemplatePath(templateType, templateName);
        log.debugf("getEmailTempate for %s", (Object)templatePath);
        String key = AttributeTheme.templateKey(templatePath);
        try {
            return MustacheProvider.templateToString(templatePath, this.getEmailThemeForRealm(this.session));
        }
        catch (IOException e) {
            throw new NotFoundException("Unable to get template " + templateName, (Throwable)e);
        }
    }

    @PUT
    @Path(value="templates/{templateType}/{templateName}")
    @Consumes(value={"multipart/form-data"})
    public Response updateEmailTemplate(@PathParam(value="templateType") String templateType, @PathParam(value="templateName") String templateName, @FormParam(value="noop") String noop) {
        if (!this.permissions.realm().canManageRealm()) {
            throw new ForbiddenException("Update email template requires manage-realm");
        }
        if (!this.templateExists(templateName)) {
            throw new NotFoundException(templateName + " not found");
        }
        MultivaluedMap formDataMap = this.session.getContext().getHttpRequest().getMultiPartFormParameters();
        if (log.isTraceEnabled()) {
            HttpRequest req = this.session.getContext().getHttpRequest();
            log.tracef("mediaType %s", (Object)req.getHttpHeaders().getMediaType());
            log.tracef("contentType %s", (Object)req.getHttpHeaders().getHeaderString("content-type"));
            MediaType mediaType = req.getHttpHeaders().getMediaType();
            log.tracef("isCompatible %b", (Object)MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible(mediaType));
            log.tracef("hasBoundary %b", (Object)mediaType.getParameters().containsKey("boundary"));
            if (formDataMap != null) {
                log.tracef("formDataMap %s", (Object)formDataMap);
                for (String k : formDataMap.keySet()) {
                    log.tracef("key %s", (Object)k);
                }
            }
        }
        if (!formDataMap.containsKey((Object)"template")) {
            throw new BadRequestException("No template part present");
        }
        String key = AttributeTheme.templateKey(this.getTemplatePath(templateType, templateName));
        try {
            String template = ((FormPartValue)formDataMap.getFirst((Object)"template")).asString();
            log.debugf("setting realm attribute %s to %s", (Object)key, (Object)template);
            this.realm.setAttribute(key, template);
            return Response.noContent().build();
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Error updating attribute for template " + key, (Throwable)e);
        }
    }
}

