/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.themes.theme;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.theme.Theme;

public class AttributeTheme
implements Theme {
    private static final Logger log = Logger.getLogger(AttributeTheme.class);
    public static final String REALM_ATTRIBUTE_KEY = "attribute-theme-realm";
    private final KeycloakSession session;
    private final File tmpdir;
    private final String name;
    private final Theme.Type type;
    private String realm;
    private File realmdir;
    public static final String LEGACY_EMAIL_TEMPLATE_ATTRIBUTE_PREFIX = "_providerConfig.templates.email";
    public static final String LEGACY_EMAIL_MESSAGE_ATTRIBUTE_PREFIX = "_providerConfig.messages.email";
    public static final String EMAIL_TEMPLATE_ATTRIBUTE_PREFIX = "_providerConfig.theme.email.templates";
    public static final String EMAIL_MESSAGE_ATTRIBUTE_PREFIX = "_providerConfig.theme.email.messages";
    public static final String EMAIL_PARENT_ATTRIBUTE_PREFIX = "_providerConfig.theme.email.parent";

    public AttributeTheme(KeycloakSession session, File tmpdir, String name, Theme.Type type) {
        this.tmpdir = tmpdir;
        this.name = name;
        this.type = type;
        this.session = session;
        this.realm = session.getContext().getRealm().getName();
    }

    private Map<String, String> getAttributes() {
        Map attrs = this.session.realms().getRealmByName(this.useRealm()).getAttributes();
        return attrs;
    }

    private String useRealm() {
        Object attr = this.session.getAttribute(REALM_ATTRIBUTE_KEY);
        String useRealm = this.realm;
        if (attr != null) {
            useRealm = attr.toString();
        }
        return useRealm;
    }

    private synchronized File getRealmDir() {
        if (this.realmdir == null) {
            try {
                Path dir = Paths.get(this.tmpdir.getAbsolutePath(), this.useRealm());
                this.realmdir = Files.exists(dir, new LinkOption[0]) ? dir.toFile() : Files.createDirectory(dir, new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.realmdir;
    }

    private String getAttribute(String key, String defaultValue) {
        return this.getAttribute(key).orElse(defaultValue);
    }

    private Optional<String> getAttribute(String key) {
        String attr = this.getAttributes().get(key);
        log.debugf("got attribute for key %s -> %s", (Object)key, (Object)attr);
        return Optional.ofNullable(attr);
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.getAttribute(EMAIL_PARENT_ATTRIBUTE_PREFIX, "mustache");
    }

    public String getImportName() {
        return null;
    }

    public Theme.Type getType() {
        return this.type;
    }

    public static String templateKey(String templateName) {
        return String.format("%s.%s", EMAIL_TEMPLATE_ATTRIBUTE_PREFIX, templateName);
    }

    public static String messageKey(String messageName) {
        return String.format("%s.%s", EMAIL_MESSAGE_ATTRIBUTE_PREFIX, messageName);
    }

    private boolean copyAttributeToFile(String name) {
        Optional<String> attr = this.getAttribute(AttributeTheme.templateKey(name));
        log.debugf("attribute %s (%s) is %s", (Object)name, (Object)AttributeTheme.templateKey(name), (Object)attr.orElse("[empty]"));
        if (!attr.isPresent()) {
            return false;
        }
        attr.ifPresent(a -> {
            try {
                Path p = this.getRealmDir().toPath().resolve(name);
                if (Files.exists(p, new LinkOption[0])) {
                    Files.deleteIfExists(p);
                }
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, a.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                log.warn((Object)"Error copying attribute to file", (Throwable)e);
            }
        });
        return true;
    }

    public URL getTemplate(String name) throws IOException {
        log.debugf("getTemplate %s", (Object)name);
        if (!this.copyAttributeToFile(name)) {
            return null;
        }
        File file = new File(this.getRealmDir(), name);
        return file.isFile() ? file.toURI().toURL() : null;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        log.debugf("getResourceAsStream %s", (Object)path);
        URL u = this.getTemplate(path);
        if (u == null) {
            return null;
        }
        return u.openConnection().getInputStream();
    }

    public Properties getMessages(Locale locale) throws IOException {
        Properties p = new Properties();
        this.getAttributes().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("_providerConfig.messages.email.")).forEach(e -> {
            String key = ((String)e.getKey()).substring(31);
            log.debugf("Adding property to bundle %s => %s", (Object)key, e.getValue());
            p.setProperty(key, (String)e.getValue());
        });
        return p;
    }

    public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
        return null;
    }

    public Properties getEnhancedMessages(RealmModel realm, Locale locale) throws IOException {
        return null;
    }

    public Properties getProperties() {
        Properties p = new Properties();
        p.setProperty("parent", this.getParentName());
        return p;
    }
}

