/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.themes.theme;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import io.phasetwo.keycloak.themes.theme.AttributeTheme;
import io.phasetwo.keycloak.themes.theme.AttributeThemeProviderFactory;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;

public class AttributeThemeProvider
implements ThemeProvider {
    private static final Logger log = Logger.getLogger(AttributeThemeProvider.class);
    private final KeycloakSession session;
    private final File tmpdir;
    public static final String ATTRIBUTE_THEME_NAME = "attributes";
    public static final Set<String> ATTRIBUTE_NAME_SET = ImmutableSet.of((Object)"attributes");

    public AttributeThemeProvider(KeycloakSession session) {
        this.session = session;
        this.tmpdir = Files.createTempDir();
    }

    public File getTmpDir() {
        return this.tmpdir;
    }

    public int getProviderPriority() {
        return 200;
    }

    public Theme getTheme(String name, Theme.Type type) throws IOException {
        if (!this.hasTheme(name, type)) {
            return null;
        }
        log.infof("Creating AttributeTheme for %s", (Object)this.session.getContext().getRealm().getName());
        return new AttributeTheme(this.session, this.tmpdir, name, type);
    }

    public Set<String> nameSet(Theme.Type type) {
        if (type == Theme.Type.EMAIL) {
            return ATTRIBUTE_NAME_SET;
        }
        return ImmutableSet.of();
    }

    public boolean hasTheme(String name, Theme.Type type) {
        return type == Theme.Type.EMAIL && ATTRIBUTE_NAME_SET.contains(name.toLowerCase());
    }

    public void close() {
        log.trace((Object)"Attempting to recursively delete tmpdir");
        try {
            AttributeThemeProviderFactory.deleteRecursively(this.tmpdir);
        }
        catch (Exception e) {
            log.warnf((Throwable)e, "Error removing tmpdir", (Object)this.tmpdir);
        }
    }
}

