/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.themes.theme;

import com.google.auto.service.AutoService;
import io.phasetwo.keycloak.themes.theme.AttributeThemeProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.theme.ThemeProvider;
import org.keycloak.theme.ThemeProviderFactory;

@AutoService(value={ThemeProviderFactory.class})
public class AttributeThemeProviderFactory
implements ThemeProviderFactory {
    private static final Logger log = Logger.getLogger(AttributeThemeProviderFactory.class);
    public static final String PROVIDER_ID = "ext-theme-provider-attribute";

    public ThemeProvider create(KeycloakSession session) {
        log.trace((Object)"Creating AttributeThemeProvider");
        return new AttributeThemeProvider(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    static void deleteRecursively(File dir) throws IOException {
        Path toDelete = dir.toPath();
        Files.walk(toDelete, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        log.tracef("%s deleted? %b", (Object)toDelete, (Object)Files.exists(toDelete, new LinkOption[0]));
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

