/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.themes.theme;

import io.phasetwo.keycloak.themes.theme.LinkExpirationFormatterFunction;
import io.phasetwo.keycloak.themes.theme.MustacheProvider;
import io.phasetwo.keycloak.themes.theme.RequiredActionFormatterFunction;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.email.EmailException;
import org.keycloak.email.freemarker.FreeMarkerEmailTemplateProvider;
import org.keycloak.email.freemarker.beans.ProfileBean;
import org.keycloak.forms.login.freemarker.model.UrlBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.Theme;
import org.keycloak.utils.StringUtil;

public class FreeMarkerAndMustacheEmailTemplateProvider
extends FreeMarkerEmailTemplateProvider {
    private static final Logger log = Logger.getLogger(FreeMarkerAndMustacheEmailTemplateProvider.class);

    public FreeMarkerAndMustacheEmailTemplateProvider(KeycloakSession session) {
        super(session);
    }

    protected FreeMarkerEmailTemplateProvider.EmailTemplate processTemplate(String subjectKey, List<Object> subjectAttributes, String template, Map<String, Object> attributes) throws EmailException {
        try {
            Theme theme = this.getTheme();
            log.infof("processTemplate for %s in theme %s", (Object)template, (Object)theme.getName());
            if (MustacheProvider.isMustacheTheme(theme) && MustacheProvider.hasMustacheTemplates(theme, template)) {
                log.infof("Using mustache template for %s in theme %s", (Object)template, (Object)theme.getName());
                return this.processMustacheTemplate(subjectKey, subjectAttributes, template, attributes);
            }
            return super.processTemplate(subjectKey, subjectAttributes, template, attributes);
        }
        catch (IOException e) {
            throw new EmailException("Failed to template email", (Throwable)e);
        }
    }

    private FreeMarkerEmailTemplateProvider.EmailTemplate processMustacheTemplate(String subjectKey, List<Object> subjectAttributes, String template, Map<String, Object> attributes) throws EmailException {
        try {
            String htmlBody;
            String textBody;
            Theme theme = this.getTheme();
            Locale locale = this.session.getContext().resolveLocale(this.user);
            attributes.put("locale", locale);
            Stream stream = this.realm.getSupportedLocalesStream();
            if (stream != null) {
                stream.forEach(loc -> {
                    String key = String.format("locale_%s", loc);
                    Boolean ok = locale.getLanguage().equals(loc);
                    attributes.put(key, ok);
                });
            }
            KeycloakUriInfo uriInfo = this.session.getContext().getUri();
            Properties rb = new Properties();
            if (!StringUtil.isNotBlank((String)this.realm.getDefaultLocale())) {
                rb.putAll((Map<?, ?>)this.realm.getRealmLocalizationTextsByLocale(this.realm.getDefaultLocale()));
            }
            rb.putAll((Map<?, ?>)theme.getMessages(locale));
            rb.putAll((Map<?, ?>)this.realm.getRealmLocalizationTextsByLocale(locale.toLanguageTag()));
            attributes.put("linkExpirationFormatter", new LinkExpirationFormatterFunction(rb, locale, attributes));
            attributes.put("requiredActionFormatter", new RequiredActionFormatterFunction(rb, locale, attributes));
            attributes.put("properties", theme.getProperties());
            attributes.put("realmName", this.getRealmName());
            attributes.put("user", new ProfileBean(this.user, this.session));
            attributes.put("url", new UrlBean(this.realm, theme, uriInfo.getBaseUri(), null));
            String subject = new MessageFormat(rb.getProperty(subjectKey, subjectKey), locale).format(subjectAttributes.toArray());
            String textTemplate = String.format("text/%s", template);
            try {
                textBody = MustacheProvider.processTemplate(attributes, textTemplate, theme);
            }
            catch (FreeMarkerException e) {
                throw new EmailException("Failed to template plain text email.", (Throwable)e);
            }
            String htmlTemplate = String.format("html/%s", template);
            try {
                htmlBody = MustacheProvider.processTemplate(attributes, htmlTemplate, theme);
            }
            catch (FreeMarkerException e) {
                throw new EmailException("Failed to template html email.", (Throwable)e);
            }
            return new FreeMarkerEmailTemplateProvider.EmailTemplate(subject, textBody, htmlBody);
        }
        catch (Exception e) {
            throw new EmailException("Failed to template email", (Throwable)e);
        }
    }
}

