/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.themes.theme;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jboss.logging.Logger;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.Theme;

public class MustacheProvider {
    private static final Logger log = Logger.getLogger(MustacheProvider.class);
    public static final String MUSTACHE_FILE_EXTENSION = "mustache";

    public static String processTemplate(Object data, String templateName, Theme theme) throws FreeMarkerException {
        templateName = MustacheProvider.getMustacheName(theme, templateName);
        try {
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            Mustache mustache = mf.compile(new StringReader(MustacheProvider.templateToString(templateName, theme)), templateName);
            StringWriter writer = new StringWriter();
            mustache.execute((Writer)writer, data);
            ((Writer)writer).flush();
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            throw new FreeMarkerException("Error processing mustache template " + templateName, (Throwable)e);
        }
    }

    public static boolean isMustacheTheme(Theme theme) {
        try {
            if (theme.getProperties() != null) {
                String type = theme.getProperties().getProperty("templateType");
                log.infof("templateType=%s", (Object)type);
                if (MUSTACHE_FILE_EXTENSION.equals(type)) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasMustacheTemplates(Theme theme, String template) {
        String nameAsMustache = MustacheProvider.getMustacheName(theme, template);
        try {
            String[] dirs;
            for (String dir : dirs = new String[]{"text", "html"}) {
                String path = String.format("%s/%s", dir, nameAsMustache);
                log.infof("Trying mustache template at %s", (Object)path);
                URL u = theme.getTemplate(path);
                if (u != null) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getMustacheName(Theme theme, String template) {
        String ext = Files.getFileExtension((String)template);
        if (ext == null || ext.equals(MUSTACHE_FILE_EXTENSION)) {
            return template;
        }
        String name = template.substring(0, template.length() - ext.length());
        return String.format("%s%s", name, MUSTACHE_FILE_EXTENSION);
    }

    public static String templateToString(String templateName, Theme theme) throws IOException {
        log.infof("templateName: %s, themeName: %s, url: %s", (Object)templateName, (Object)theme.getName(), (Object)theme.getTemplate(templateName));
        return Resources.toString((URL)theme.getTemplate(templateName), (Charset)StandardCharsets.UTF_8);
    }
}

