/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.portal;

import com.google.auto.service.AutoService;
import io.phasetwo.portal.PortalResourceProvider;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.AccountResourceProvider;
import org.keycloak.services.resource.AccountResourceProviderFactory;

@AutoService(value={AccountResourceProviderFactory.class})
public class AccountPortalResourceProviderFactory
implements AccountResourceProviderFactory {
    private static final Logger log = Logger.getLogger(AccountPortalResourceProviderFactory.class);
    public static final String ID = "portal";

    public String getId() {
        return ID;
    }

    public AccountResourceProvider create(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        String override = realm.getName();
        return new PortalResourceProvider(session, override);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RealmModel.RealmPostCreateEvent) {
                log.debug((Object)"RealmPostCreateEvent");
                this.realmPostCreate((RealmModel.RealmPostCreateEvent)event);
            }
        });
    }

    private void realmPostCreate(RealmModel.RealmPostCreateEvent event) {
    }

    public void close() {
    }
}

