/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.portal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import org.keycloak.common.Profile;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.Auth;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"profileEnabled", "registrationEmailAsUsername", "passwordUpdateAllowed", "twoFactorUpdateAllowed", "totpConfigured", "passwordlessUpdateAllowed", "deviceActivityEnabled", "linkedAccountsEnabled", "eventsEnabled", "editUsernameAllowed", "internationalizationEnabled", "resourcesEnabled", "viewGroupsEnabled", "deleteAccountAllowed", "updateEmailFeatureEnabled", "updateEmailActionEnabled", "organizationsEnabled", "orgDetailsEnabled", "orgMembersEnabled", "orgInvitationsEnabled", "orgDomainsEnabled", "orgSsoEnabled", "orgEventsEnabled"})
public class PortalFeatures {
    @JsonProperty(value="profileEnabled")
    private Boolean profileEnabled;
    @JsonProperty(value="registrationEmailAsUsername")
    private Boolean registrationEmailAsUsername;
    @JsonProperty(value="passwordUpdateAllowed")
    private Boolean passwordUpdateAllowed;
    @JsonProperty(value="twoFactorUpdateAllowed")
    private Boolean twoFactorUpdateAllowed;
    @JsonProperty(value="totpConfigured")
    private Boolean totpConfigured;
    @JsonProperty(value="passwordlessUpdateAllowed")
    private Boolean passwordlessUpdateAllowed;
    @JsonProperty(value="deviceActivityEnabled")
    private Boolean deviceActivityEnabled;
    @JsonProperty(value="linkedAccountsEnabled")
    private Boolean linkedAccountsEnabled;
    @JsonProperty(value="eventsEnabled")
    private Boolean eventsEnabled;
    @JsonProperty(value="editUsernameAllowed")
    private Boolean editUsernameAllowed;
    @JsonProperty(value="internationalizationEnabled")
    private Boolean internationalizationEnabled;
    @JsonProperty(value="resourcesEnabled")
    private Boolean resourcesEnabled;
    @JsonProperty(value="viewGroupsEnabled")
    private Boolean viewGroupsEnabled;
    @JsonProperty(value="deleteAccountAllowed")
    private Boolean deleteAccountAllowed;
    @JsonProperty(value="updateEmailFeatureEnabled")
    private Boolean updateEmailFeatureEnabled;
    @JsonProperty(value="updateEmailActionEnabled")
    private Boolean updateEmailActionEnabled;
    @JsonProperty(value="organizationsEnabled")
    private Boolean organizationsEnabled;
    @JsonProperty(value="orgDetailsEnabled")
    private Boolean orgDetailsEnabled;
    @JsonProperty(value="orgMembersEnabled")
    private Boolean orgMembersEnabled;
    @JsonProperty(value="orgInvitationsEnabled")
    private Boolean orgInvitationsEnabled;
    @JsonProperty(value="orgDomainsEnabled")
    private Boolean orgDomainsEnabled;
    @JsonProperty(value="orgSsoEnabled")
    private Boolean orgSsoEnabled;
    @JsonProperty(value="orgEventsEnabled")
    private Boolean orgEventsEnabled;

    public static String CONFIG_KEY(String property) {
        return String.format("_providerConfig.portal.%s", property);
    }

    public static boolean CONFIG_ENABLED(RealmModel realm, String property, boolean defaultValue) {
        String v = realm.getAttribute(PortalFeatures.CONFIG_KEY(property));
        if (v == null) {
            return defaultValue;
        }
        return "true".equals(v);
    }

    public static PortalFeatures fromSession(KeycloakSession session, Auth auth) {
        RealmModel realm = session.getContext().getRealm();
        UserModel user = null;
        boolean isTotpConfigured = false;
        boolean deleteAccountAllowed = false;
        boolean isViewGroupsEnabled = false;
        if (auth != null) {
            user = auth.getUser();
            isTotpConfigured = user.credentialManager().isConfiguredFor(realm.getOTPPolicy().getType());
            RoleModel deleteAccountRole = realm.getClientByClientId("account").getRole("delete-account");
            deleteAccountAllowed = deleteAccountRole != null && user.hasRole(deleteAccountRole) && realm.getRequiredActionProviderByAlias("delete_account").isEnabled();
            RoleModel viewGrouRole = realm.getClientByClientId("account").getRole("view-groups");
            isViewGroupsEnabled = viewGrouRole != null && user.hasRole(viewGrouRole);
        }
        URI uri = session.getContext().getAuthServerUrl();
        PortalFeatures config = new PortalFeatures();
        config.profileEnabled(PortalFeatures.CONFIG_ENABLED(realm, "profile.enabled", true));
        config.registrationEmailAsUsername(realm.isRegistrationEmailAsUsername());
        config.passwordUpdateAllowed(PortalFeatures.CONFIG_ENABLED(realm, "profile.password.enabled", true));
        config.twoFactorUpdateAllowed(PortalFeatures.CONFIG_ENABLED(realm, "profile.twofactor.enabled", true));
        config.totpConfigured(isTotpConfigured);
        config.passwordlessUpdateAllowed(PortalFeatures.CONFIG_ENABLED(realm, "profile.passwordless.enabled", true));
        config.deviceActivityEnabled(PortalFeatures.CONFIG_ENABLED(realm, "profile.activity.enabled", true));
        config.linkedAccountsEnabled(realm.isIdentityFederationEnabled() && PortalFeatures.CONFIG_ENABLED(realm, "profile.linked.enabled", true));
        EventStoreProvider eventStore = (EventStoreProvider)session.getProvider(EventStoreProvider.class);
        config.eventsEnabled(eventStore != null && realm.isEventsEnabled());
        config.editUsernameAllowed(realm.isEditUsernameAllowed());
        config.internationalizationEnabled(realm.isInternationalizationEnabled());
        config.resourcesEnabled(realm.isUserManagedAccessAllowed());
        config.viewGroupsEnabled(isViewGroupsEnabled);
        config.deleteAccountAllowed(deleteAccountAllowed);
        config.updateEmailFeatureEnabled(Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL));
        RequiredActionProviderModel updateEmailActionProvider = realm.getRequiredActionProviderByAlias(UserModel.RequiredAction.UPDATE_EMAIL.name());
        config.updateEmailActionEnabled(updateEmailActionProvider != null && updateEmailActionProvider.isEnabled());
        config.organizationsEnabled(PortalFeatures.CONFIG_ENABLED(realm, "org.enabled", true));
        config.orgDetailsEnabled(PortalFeatures.CONFIG_ENABLED(realm, "org.details.enabled", true));
        config.orgMembersEnabled(PortalFeatures.CONFIG_ENABLED(realm, "org.members.enabled", true));
        config.orgInvitationsEnabled(PortalFeatures.CONFIG_ENABLED(realm, "org.invitations.enabled", true));
        config.orgDomainsEnabled(PortalFeatures.CONFIG_ENABLED(realm, "org.domains.enabled", true));
        config.orgSsoEnabled(PortalFeatures.CONFIG_ENABLED(realm, "org.sso.enabled", true));
        config.orgEventsEnabled(PortalFeatures.CONFIG_ENABLED(realm, "org.events.enabled", true));
        return config;
    }

    @JsonProperty(value="profileEnabled")
    public Boolean getProfileEnabled() {
        return this.profileEnabled;
    }

    @JsonProperty(value="profileEnabled")
    public void setProfileEnabled(Boolean profileEnabled) {
        this.profileEnabled = profileEnabled;
    }

    public PortalFeatures profileEnabled(Boolean profileEnabled) {
        this.profileEnabled = profileEnabled;
        return this;
    }

    @JsonProperty(value="registrationEmailAsUsername")
    public Boolean getRegistrationEmailAsUsername() {
        return this.registrationEmailAsUsername;
    }

    @JsonProperty(value="registrationEmailAsUsername")
    public void setRegistrationEmailAsUsername(Boolean registrationEmailAsUsername) {
        this.registrationEmailAsUsername = registrationEmailAsUsername;
    }

    public PortalFeatures registrationEmailAsUsername(Boolean registrationEmailAsUsername) {
        this.registrationEmailAsUsername = registrationEmailAsUsername;
        return this;
    }

    @JsonProperty(value="passwordUpdateAllowed")
    public Boolean getPasswordUpdateAllowed() {
        return this.passwordUpdateAllowed;
    }

    @JsonProperty(value="passwordUpdateAllowed")
    public void setPasswordUpdateAllowed(Boolean passwordUpdateAllowed) {
        this.passwordUpdateAllowed = passwordUpdateAllowed;
    }

    public PortalFeatures passwordUpdateAllowed(Boolean passwordUpdateAllowed) {
        this.passwordUpdateAllowed = passwordUpdateAllowed;
        return this;
    }

    @JsonProperty(value="twoFactorUpdateAllowed")
    public Boolean getTwoFactorUpdateAllowed() {
        return this.twoFactorUpdateAllowed;
    }

    @JsonProperty(value="twoFactorUpdateAllowed")
    public void setTwoFactorUpdateAllowed(Boolean twoFactorUpdateAllowed) {
        this.twoFactorUpdateAllowed = twoFactorUpdateAllowed;
    }

    public PortalFeatures twoFactorUpdateAllowed(Boolean twoFactorUpdateAllowed) {
        this.twoFactorUpdateAllowed = twoFactorUpdateAllowed;
        return this;
    }

    @JsonProperty(value="totpConfigured")
    public Boolean getTotpConfigured() {
        return this.totpConfigured;
    }

    @JsonProperty(value="totpConfigured")
    public void setTotpConfigured(Boolean totpConfigured) {
        this.totpConfigured = totpConfigured;
    }

    public PortalFeatures totpConfigured(Boolean totpConfigured) {
        this.totpConfigured = totpConfigured;
        return this;
    }

    @JsonProperty(value="passwordlessUpdateAllowed")
    public Boolean getPasswordlessUpdateAllowed() {
        return this.passwordlessUpdateAllowed;
    }

    @JsonProperty(value="passwordlessUpdateAllowed")
    public void setPasswordlessUpdateAllowed(Boolean passwordlessUpdateAllowed) {
        this.passwordlessUpdateAllowed = passwordlessUpdateAllowed;
    }

    public PortalFeatures passwordlessUpdateAllowed(Boolean passwordlessUpdateAllowed) {
        this.passwordlessUpdateAllowed = passwordlessUpdateAllowed;
        return this;
    }

    @JsonProperty(value="deviceActivityEnabled")
    public Boolean getDeviceActivityEnabled() {
        return this.deviceActivityEnabled;
    }

    @JsonProperty(value="deviceActivityEnabled")
    public void setDeviceActivityEnabled(Boolean deviceActivityEnabled) {
        this.deviceActivityEnabled = deviceActivityEnabled;
    }

    public PortalFeatures deviceActivityEnabled(Boolean deviceActivityEnabled) {
        this.deviceActivityEnabled = deviceActivityEnabled;
        return this;
    }

    @JsonProperty(value="linkedAccountsEnabled")
    public Boolean getLinkedAccountsEnabled() {
        return this.linkedAccountsEnabled;
    }

    @JsonProperty(value="linkedAccountsEnabled")
    public void setLinkedAccountsEnabled(Boolean linkedAccountsEnabled) {
        this.linkedAccountsEnabled = linkedAccountsEnabled;
    }

    public PortalFeatures linkedAccountsEnabled(Boolean linkedAccountsEnabled) {
        this.linkedAccountsEnabled = linkedAccountsEnabled;
        return this;
    }

    @JsonProperty(value="eventsEnabled")
    public Boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    @JsonProperty(value="eventsEnabled")
    public void setEventsEnabled(Boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
    }

    public PortalFeatures eventsEnabled(Boolean eventsEnabled) {
        this.eventsEnabled = eventsEnabled;
        return this;
    }

    @JsonProperty(value="editUsernameAllowed")
    public Boolean getEditUsernameAllowed() {
        return this.editUsernameAllowed;
    }

    @JsonProperty(value="editUsernameAllowed")
    public void setEditUsernameAllowed(Boolean editUsernameAllowed) {
        this.editUsernameAllowed = editUsernameAllowed;
    }

    public PortalFeatures editUsernameAllowed(Boolean editUsernameAllowed) {
        this.editUsernameAllowed = editUsernameAllowed;
        return this;
    }

    @JsonProperty(value="internationalizationEnabled")
    public Boolean getInternationalizationEnabled() {
        return this.internationalizationEnabled;
    }

    @JsonProperty(value="internationalizationEnabled")
    public void setInternationalizationEnabled(Boolean internationalizationEnabled) {
        this.internationalizationEnabled = internationalizationEnabled;
    }

    public PortalFeatures internationalizationEnabled(Boolean internationalizationEnabled) {
        this.internationalizationEnabled = internationalizationEnabled;
        return this;
    }

    @JsonProperty(value="resourcesEnabled")
    public Boolean getResourcesEnabled() {
        return this.resourcesEnabled;
    }

    @JsonProperty(value="resourcesEnabled")
    public void setResourcesEnabled(Boolean resourcesEnabled) {
        this.resourcesEnabled = resourcesEnabled;
    }

    public PortalFeatures resourcesEnabled(Boolean resourcesEnabled) {
        this.resourcesEnabled = resourcesEnabled;
        return this;
    }

    @JsonProperty(value="viewGroupsEnabled")
    public Boolean getViewGroupsEnabled() {
        return this.viewGroupsEnabled;
    }

    @JsonProperty(value="viewGroupsEnabled")
    public void setViewGroupsEnabled(Boolean viewGroupsEnabled) {
        this.viewGroupsEnabled = viewGroupsEnabled;
    }

    public PortalFeatures viewGroupsEnabled(Boolean viewGroupsEnabled) {
        this.viewGroupsEnabled = viewGroupsEnabled;
        return this;
    }

    @JsonProperty(value="deleteAccountAllowed")
    public Boolean getDeleteAccountAllowed() {
        return this.deleteAccountAllowed;
    }

    @JsonProperty(value="deleteAccountAllowed")
    public void setDeleteAccountAllowed(Boolean deleteAccountAllowed) {
        this.deleteAccountAllowed = deleteAccountAllowed;
    }

    public PortalFeatures deleteAccountAllowed(Boolean deleteAccountAllowed) {
        this.deleteAccountAllowed = deleteAccountAllowed;
        return this;
    }

    @JsonProperty(value="updateEmailFeatureEnabled")
    public Boolean getUpdateEmailFeatureEnabled() {
        return this.updateEmailFeatureEnabled;
    }

    @JsonProperty(value="updateEmailFeatureEnabled")
    public void setUpdateEmailFeatureEnabled(Boolean updateEmailFeatureEnabled) {
        this.updateEmailFeatureEnabled = updateEmailFeatureEnabled;
    }

    public PortalFeatures updateEmailFeatureEnabled(Boolean updateEmailFeatureEnabled) {
        this.updateEmailFeatureEnabled = updateEmailFeatureEnabled;
        return this;
    }

    @JsonProperty(value="updateEmailActionEnabled")
    public Boolean getUpdateEmailActionEnabled() {
        return this.updateEmailActionEnabled;
    }

    @JsonProperty(value="updateEmailActionEnabled")
    public void setUpdateEmailActionEnabled(Boolean updateEmailActionEnabled) {
        this.updateEmailActionEnabled = updateEmailActionEnabled;
    }

    public PortalFeatures updateEmailActionEnabled(Boolean updateEmailActionEnabled) {
        this.updateEmailActionEnabled = updateEmailActionEnabled;
        return this;
    }

    @JsonProperty(value="organizationsEnabled")
    public Boolean getOrganizationsEnabled() {
        return this.organizationsEnabled;
    }

    @JsonProperty(value="organizationsEnabled")
    public void setOrganizationsEnabled(Boolean organizationsEnabled) {
        this.organizationsEnabled = organizationsEnabled;
    }

    public PortalFeatures organizationsEnabled(Boolean organizationsEnabled) {
        this.organizationsEnabled = organizationsEnabled;
        return this;
    }

    @JsonProperty(value="orgDetailsEnabled")
    public Boolean getOrgDetailsEnabled() {
        return this.orgDetailsEnabled;
    }

    @JsonProperty(value="orgDetailsEnabled")
    public void setOrgDetailsEnabled(Boolean orgDetailsEnabled) {
        this.orgDetailsEnabled = orgDetailsEnabled;
    }

    public PortalFeatures orgDetailsEnabled(Boolean orgDetailsEnabled) {
        this.orgDetailsEnabled = orgDetailsEnabled;
        return this;
    }

    @JsonProperty(value="orgMembersEnabled")
    public Boolean getOrgMembersEnabled() {
        return this.orgMembersEnabled;
    }

    @JsonProperty(value="orgMembersEnabled")
    public void setOrgMembersEnabled(Boolean orgMembersEnabled) {
        this.orgMembersEnabled = orgMembersEnabled;
    }

    public PortalFeatures orgMembersEnabled(Boolean orgMembersEnabled) {
        this.orgMembersEnabled = orgMembersEnabled;
        return this;
    }

    @JsonProperty(value="orgInvitationsEnabled")
    public Boolean getOrgInvitationsEnabled() {
        return this.orgInvitationsEnabled;
    }

    @JsonProperty(value="orgInvitationsEnabled")
    public void setOrgInvitationsEnabled(Boolean orgInvitationsEnabled) {
        this.orgInvitationsEnabled = orgInvitationsEnabled;
    }

    public PortalFeatures orgInvitationsEnabled(Boolean orgInvitationsEnabled) {
        this.orgInvitationsEnabled = orgInvitationsEnabled;
        return this;
    }

    @JsonProperty(value="orgDomainsEnabled")
    public Boolean getOrgDomainsEnabled() {
        return this.orgDomainsEnabled;
    }

    @JsonProperty(value="orgDomainsEnabled")
    public void setOrgDomainsEnabled(Boolean orgDomainsEnabled) {
        this.orgDomainsEnabled = orgDomainsEnabled;
    }

    public PortalFeatures orgDomainsEnabled(Boolean orgDomainsEnabled) {
        this.orgDomainsEnabled = orgDomainsEnabled;
        return this;
    }

    @JsonProperty(value="orgSsoEnabled")
    public Boolean getOrgSsoEnabled() {
        return this.orgSsoEnabled;
    }

    @JsonProperty(value="orgSsoEnabled")
    public void setOrgSsoEnabled(Boolean orgSsoEnabled) {
        this.orgSsoEnabled = orgSsoEnabled;
    }

    public PortalFeatures orgSsoEnabled(Boolean orgSsoEnabled) {
        this.orgSsoEnabled = orgSsoEnabled;
        return this;
    }

    @JsonProperty(value="orgEventsEnabled")
    public Boolean getOrgEventsEnabled() {
        return this.orgEventsEnabled;
    }

    @JsonProperty(value="orgEventsEnabled")
    public void setOrgEventsEnabled(Boolean orgEventsEnabled) {
        this.orgEventsEnabled = orgEventsEnabled;
    }

    public PortalFeatures orgEventsEnabled(Boolean orgEventsEnabled) {
        this.orgEventsEnabled = orgEventsEnabled;
        return this;
    }
}

