/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.portal;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.phasetwo.portal.PortalEnvironment;
import io.phasetwo.portal.PortalFeatures;
import jakarta.activation.MimetypesFileTypeMap;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.FreeMarkerLoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.services.Urls;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resource.AccountResourceProvider;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.theme.Theme;

public class PortalResourceProvider
implements AccountResourceProvider,
RealmResourceProvider {
    private static final Logger log = Logger.getLogger(PortalResourceProvider.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private final KeycloakSession session;
    private final String authRealmOverride;
    private final AppAuthManager authManager;
    private Auth auth;
    public static final String[] METHODS = new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"};
    private static final String MIME_TYPES = "text/javascript js\ntext/css css\nfont/woff woff\nfont/woff2 woff2\napplication/json json webmanifest map\nimage/svg+xml svg\n";

    public PortalResourceProvider(KeycloakSession session, String authRealmOverride) {
        this.session = session;
        this.authRealmOverride = authRealmOverride;
        this.authManager = new AppAuthManager();
    }

    public void init() {
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateIdentityCookie(this.session, this.session.getContext().getRealm());
        if (authResult != null) {
            this.auth = new Auth(this.session.getContext().getRealm(), authResult.getToken(), authResult.getUser(), this.session.getContext().getClient(), authResult.getSession(), true);
        }
    }

    public Object getResource() {
        return this;
    }

    private void setupCors() {
        Cors.builder().allowAllOrigins().allowedMethods(METHODS).auth().add();
    }

    private String getRealmName(RealmModel realm) {
        if (!Strings.isNullOrEmpty((String)realm.getDisplayName())) {
            return realm.getDisplayName();
        }
        return realm.getName();
    }

    @OPTIONS
    @Path(value="{any:.*}")
    public Response preflight() {
        log.debug((Object)"CORS OPTIONS preflight request");
        return Cors.builder().auth().allowedMethods(METHODS).preflight().add(Response.ok());
    }

    @GET
    @Path(value="{path:.+}")
    public Response router(@PathParam(value="path") String path) throws Exception {
        Response response;
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        log.debugf("param path %s", (Object)path);
        log.debugf("absolutePath %s", (Object)uriInfo.getAbsolutePath());
        log.debugf("path %s", (Object)uriInfo.getPath());
        log.debugf("baseUri %s", (Object)uriInfo.getBaseUri());
        log.debugf("segments %s", (Object)uriInfo.getPathSegments());
        log.debugf("requestUri %s", (Object)uriInfo.getRequestUri());
        if (path == null || "".equals(path) || "/".equals(path)) {
            return this.portal();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (Pattern.matches("^(asset-manifest|logo|manifest|static|locales|favicon).*", path) && (response = this.staticResources(path)) != null) {
            log.debugf("returning response %d for path %s", response.getStatus(), (Object)path);
            return response;
        }
        if (Pattern.matches("^(profile|organizations).*", path) && (response = this.forward()) != null) {
            log.debugf("forwarding response %d for path %s", response.getStatus(), (Object)path);
            return response;
        }
        return this.portal();
    }

    @GET
    @Path(value="{path: ^(profile|organizations).*}")
    @Produces(value={"text/html"})
    public Response forward() {
        return this.portal();
    }

    @GET
    @Produces(value={"text/html"})
    public Response portal() {
        this.init();
        RealmModel realm = this.session.getContext().getRealm();
        Theme theme = this.getTheme("portal");
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        URI authUrl = uriInfo.getBaseUri();
        URI portalBaseUrl = uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(realm.getName()).path("portal").path("/").build(new Object[]{realm});
        String portalResources = Urls.themeRoot((URI)authUrl).getPath() + "/admin-portal/" + theme.getName();
        Locale locale = new Locale("en");
        try {
            locale = this.auth != null && this.auth.getUser() != null ? this.session.getContext().resolveLocale(this.auth.getUser()) : new Locale(realm.getDefaultLocale() != null ? realm.getDefaultLocale() : "en");
        }
        catch (Exception e) {
            log.warn((Object)"Unable to determine locale.");
        }
        try {
            String referer = (String)this.session.getContext().getHttpRequest().getHttpHeaders().getRequestHeaders().getFirst((Object)"Referer");
            PortalEnvironment env = new PortalEnvironment().realm(realm.getName()).locale(locale.toLanguageTag()).authServerUrl((String)(authUrl.getPath().endsWith("/") ? authUrl.toString() : authUrl.toString() + "/")).baseUrl(portalBaseUrl.toString()).resourceUrl(portalResources).refererUrl(referer).isRunningAsTheme(true).supportedLocales(this.getSupportedLocales(realm, locale)).styles(new PortalEnvironment.CustomTheme());
            Optional.ofNullable(realm.getName()).ifPresent(a -> env.name((String)a));
            Optional.ofNullable(realm.getDisplayName()).ifPresent(a -> env.displayName((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.logo.url", new Object[0]))).ifPresent(a -> env.logoUrl((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.favicon.url", new Object[0]))).ifPresent(a -> env.faviconUrl((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.appicon.url", new Object[0]))).ifPresent(a -> env.appiconUrl((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.primaryColor100", new Object[0]))).ifPresent(a -> env.getStyles().setPrimary100((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.primaryColor200", new Object[0]))).ifPresent(a -> env.getStyles().setPrimary200((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.primaryColor400", new Object[0]))).ifPresent(a -> env.getStyles().setPrimary400((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.primaryColor500", new Object[0]))).ifPresent(a -> env.getStyles().setPrimary500((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.primaryColor600", new Object[0]))).ifPresent(a -> env.getStyles().setPrimary600((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.primaryColor700", new Object[0]))).ifPresent(a -> env.getStyles().setPrimary700((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.primaryColor900", new Object[0]))).ifPresent(a -> env.getStyles().setPrimary900((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.secondaryColor800", new Object[0]))).ifPresent(a -> env.getStyles().setSecondary800((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.secondaryColor900", new Object[0]))).ifPresent(a -> env.getStyles().setSecondary900((String)a));
            Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.portal.css", new Object[0]))).ifPresent(a -> env.getStyles().setCustomCSS((String)a));
            env.setFeatures(PortalFeatures.fromSession(this.session, this.auth));
            String envStr = new String(JsonStringEncoder.getInstance().quoteAsString(mapper.writeValueAsString((Object)env)));
            log.infof("set environment string to %s", (Object)envStr);
            String authUrlAttribute = authUrl.getPath().endsWith("/") ? authUrl.toString().substring(0, authUrl.toString().length() - 1) : authUrl.toString();
            String realmName = this.getRealmName(realm);
            LoginFormsProvider form = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAttribute("environment", (Object)envStr).setAttribute("authUrl", (Object)authUrlAttribute).setAttribute("faviconUrl", (Object)Optional.ofNullable(realm.getAttribute("_providerConfig.assets.favicon.url")).orElse(String.format("%s/realms/%s/portal/favicon.ico", authUrlAttribute, realm.getName()))).setAttribute("appiconUrl", (Object)Optional.ofNullable(realm.getAttribute("_providerConfig.assets.appicon.url")).orElse(String.format("%s/realms/%s/portal/logo192.png", authUrlAttribute, realm.getName()))).setAttribute("displayName", (Object)realmName).setAttribute("realmName", (Object)realm.getName());
            FreeMarkerLoginFormsProvider fm = (FreeMarkerLoginFormsProvider)form;
            Method processTemplateMethod = fm.getClass().getDeclaredMethod("processTemplate", Theme.class, String.class, Locale.class);
            processTemplateMethod.setAccessible(true);
            Response resp = (Response)processTemplateMethod.invoke((Object)fm, theme, "portal.ftl", this.session.getContext().resolveLocale(null));
            return resp;
        }
        catch (Exception e) {
            log.warn((Object)"Could not call processTemplate on FreeMarkerLoginFormsProvider", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    Map<String, String> getSupportedLocales(RealmModel realm, Locale locale) {
        Properties messages = new Properties();
        if (!Strings.isNullOrEmpty((String)realm.getDefaultLocale())) {
            messages.putAll((Map<?, ?>)realm.getRealmLocalizationTextsByLocale(realm.getDefaultLocale()));
        }
        if (locale != null) {
            messages.putAll((Map<?, ?>)realm.getRealmLocalizationTextsByLocale(locale.toLanguageTag()));
        }
        return realm.getSupportedLocalesStream().collect(Collectors.toMap(Function.identity(), l -> messages.getProperty("locale_" + l, (String)l)));
    }

    @GET
    @Path(value="{path: ^(asset-manifest|logo|manifest|static|locales|favicon).*}")
    public Response staticResources(@PathParam(value="path") String path) throws IOException {
        String fileName = this.getLastPathSegment((UriInfo)this.session.getContext().getUri());
        Theme theme = this.getTheme("portal");
        InputStream resource = theme.getResourceAsStream(path);
        String mimeType = this.getMimeType(fileName);
        log.debugf("%s [%s] (%s)", (Object)path, (Object)mimeType, (Object)(null == resource ? "404" : "200"));
        return null == resource ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok((Object)resource, (String)mimeType).build();
    }

    @GET
    @Path(value="/keycloak.json")
    @Produces(value={"application/json"})
    public Response keycloakJson() {
        this.setupCors();
        RealmModel realm = this.session.getContext().getRealm();
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        ImmutableMap json = ImmutableMap.of((Object)"realm", (Object)this.authRealmOverride, (Object)"auth-server-url", (Object)PortalResourceProvider.getBaseUrl((UriInfo)uriInfo), (Object)"resource", (Object)"admin-portal");
        return Response.ok((Object)json).build();
    }

    private static String getBaseUrl(UriInfo uriInfo) {
        String u = uriInfo.getBaseUri().toString();
        if (u != null && u.endsWith("/")) {
            u = u.substring(0, u.length() - 1);
        }
        return u;
    }

    private static String getOrigin(UriInfo uriInfo) {
        return uriInfo.getBaseUri().resolve("/").toString();
    }

    private Theme getTheme(String name) {
        try {
            return this.session.theme().getTheme(name, Theme.Type.LOGIN);
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getLastPathSegment(UriInfo uriInfo) {
        List segs = uriInfo.getPathSegments();
        if (segs != null && segs.size() > 0) {
            return ((PathSegment)segs.get(segs.size() - 1)).getPath();
        }
        return null;
    }

    private String getMimeType(String fileName) {
        MimetypesFileTypeMap map = new MimetypesFileTypeMap();
        map.addMimeTypes(MIME_TYPES);
        return map.getContentType(fileName);
    }

    public void close() {
    }
}

