/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.portal;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.phasetwo.portal.PortalResourceProvider;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;

@AutoService(value={RealmResourceProviderFactory.class})
public class PortalResourceProviderFactory
implements RealmResourceProviderFactory {
    private static final Logger log = Logger.getLogger(PortalResourceProviderFactory.class);
    public static final String ID = "portal";
    public static final String NAME = "Admin portal";
    public static final String DESCRIPTION = "Portal for self-administration of profile and organizations.";

    public String getId() {
        return ID;
    }

    public RealmResourceProvider create(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        String override = realm.getName();
        return new PortalResourceProvider(session, override);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RealmModel.RealmPostCreateEvent) {
                log.debug((Object)"RealmPostCreateEvent");
                this.realmPostCreate((RealmModel.RealmPostCreateEvent)event);
            }
        });
    }

    private void initClients(KeycloakSession session) {
        try {
            session.realms().getRealmsStream().forEach(realm -> this.createClient((RealmModel)realm, session));
        }
        catch (Exception e) {
            log.warnf("Error initializing admin-portal clients. Ignoring. You may have to create them manually. %s", (Object)e.getMessage());
        }
    }

    private void realmPostCreate(RealmModel.RealmPostCreateEvent event) {
        RealmModel realm = event.getCreatedRealm();
        KeycloakSession session = event.getKeycloakSession();
        this.createClient(realm, session);
    }

    private void createClient(RealmModel realm, KeycloakSession session) {
        log.debugf("Creating %s realm admin-portal client.", (Object)realm.getName());
        ClientModel adminPortal = session.clients().getClientByClientId(realm, "admin-portal");
        if (adminPortal == null) {
            log.debugf("No admin-portal client for %s realm. Creating...", (Object)realm.getName());
            adminPortal = "master".equals(realm.getName()) ? this.createClientForMaster(realm, session) : this.createClientForRealm(realm, session);
            this.updateAccountConsoleForRealm(realm, session);
        }
        this.setClientScopeDefaults(realm, session, adminPortal);
    }

    private String getRedirectPath(RealmModel realm) {
        return String.format("/realms/%s/%s/", realm.getName(), ID);
    }

    private ClientModel createClientForRealm(RealmModel realm, KeycloakSession session) {
        String path = this.getRedirectPath(realm);
        ClientModel adminPortal = session.clients().addClient(realm, "admin-portal");
        this.setDefaults(realm, adminPortal);
        adminPortal.setRedirectUris((Set)ImmutableSet.of((Object)String.format("%s*", path)));
        adminPortal.setWebOrigins((Set)ImmutableSet.of((Object)"/*"));
        adminPortal.setAttribute("post.logout.redirect.uris", "+");
        return adminPortal;
    }

    private void updateAccountConsoleForRealm(RealmModel realm, KeycloakSession session) {
        ClientModel accountConsole = session.clients().getClientByClientId(realm, "account-console");
        accountConsole.addRedirectUri(String.format("%s*", this.getRedirectPath(realm)));
    }

    private ClientModel createClientForMaster(RealmModel realm, KeycloakSession session) {
        ClientModel adminPortal = session.clients().addClient(realm, "admin-portal");
        this.setDefaults(realm, adminPortal);
        adminPortal.setRedirectUris((Set)ImmutableSet.of((Object)"/*"));
        adminPortal.setWebOrigins((Set)ImmutableSet.of((Object)"/*"));
        adminPortal.setAttribute("post.logout.redirect.uris", "+");
        return adminPortal;
    }

    private void setDefaults(RealmModel realm, ClientModel adminPortal) {
        adminPortal.setProtocol("openid-connect");
        adminPortal.setPublicClient(true);
        adminPortal.setRootUrl("${authBaseUrl}");
        adminPortal.setName(NAME);
        adminPortal.setDescription(DESCRIPTION);
        adminPortal.setBaseUrl(this.getRedirectPath(realm));
    }

    private void setOrganizationRoleMapper(ClientModel adminPortal) {
        ProtocolMapperModel pro = adminPortal.getProtocolMapperByName("openid-connect", "organizations");
        if (pro != null) {
            return;
        }
        pro = new ProtocolMapperModel();
        pro.setProtocolMapper("oidc-organization-role-mapper");
        pro.setProtocol("openid-connect");
        pro.setName("organizations");
        ImmutableMap config = new ImmutableMap.Builder().put((Object)"id.token.claim", (Object)"true").put((Object)"access.token.claim", (Object)"true").put((Object)"claim.name", (Object)"organizations").put((Object)"jsonType.label", (Object)"JSON").put((Object)"userinfo.token.claim", (Object)"true").build();
        pro.setConfig((Map)config);
        adminPortal.addProtocolMapper(pro);
    }

    private void setOrganizationIdMapper(ClientModel adminPortal) {
        ProtocolMapperModel pro = adminPortal.getProtocolMapperByName("openid-connect", "org_id");
        if (pro != null) {
            return;
        }
        pro = new ProtocolMapperModel();
        pro.setProtocolMapper("oidc-usersessionmodel-note-mapper");
        pro.setProtocol("openid-connect");
        pro.setName("org_id");
        ImmutableMap config = new ImmutableMap.Builder().put((Object)"user.session.note", (Object)"org_id").put((Object)"id.token.claim", (Object)"true").put((Object)"access.token.claim", (Object)"true").put((Object)"claim.name", (Object)"org_id").put((Object)"jsonType.label", (Object)"String").put((Object)"userinfo.token.claim", (Object)"true").build();
        pro.setConfig((Map)config);
        adminPortal.addProtocolMapper(pro);
    }

    private void setClientScopeDefaults(RealmModel realm, KeycloakSession session, ClientModel adminPortal) {
        adminPortal.setFullScopeAllowed(true);
        session.clientScopes().getClientScopesStream(realm).filter(c -> c.getRealm().equals((Object)realm) && c.getName().equals("roles")).forEach(c -> {
            log.debugf("Found 'roles' client scope. Adding as default...", new Object[0]);
            try {
                adminPortal.addClientScope(c, true);
            }
            catch (Exception e) {
                log.warn((Object)"'roles' client scope already exists. skipping...");
            }
        });
        this.setOrganizationRoleMapper(adminPortal);
        this.setOrganizationIdMapper(adminPortal);
    }

    public void close() {
    }
}

