/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.wizard;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

@JsonPropertyOrder(value={"domain", "name", "displayName", "logoUrl", "apiMode", "enableGroupMapping", "enableLdap", "enableDashboard", "emailAsUsername", "trustEmail", "usernameMapperImport"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WizardConfig {
    @JsonProperty(value="domain")
    private String domain;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="logoUrl")
    private String logoUrl;
    @JsonProperty(value="apiMode")
    private String apiMode = "onprem";
    @JsonProperty(value="enableGroupMapping")
    private boolean enableGroupMapping = true;
    @JsonProperty(value="enableLdap")
    private boolean enableLdap = true;
    @JsonProperty(value="enableDashboard")
    private boolean enableDashboard = true;
    @JsonProperty(value="emailAsUsername")
    private boolean emailAsUsername = false;
    @JsonProperty(value="trustEmail")
    private boolean trustEmail = false;
    @JsonProperty(value="usernameMapperImport")
    private boolean usernameMapperImport = true;

    public static String CONFIG_KEY(String property) {
        return String.format("_providerConfig.wizard.%s", property);
    }

    public static WizardConfig createFromAttributes(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        URI uri = session.getContext().getAuthServerUrl();
        WizardConfig config = new WizardConfig();
        Optional.ofNullable(realm.getAttribute(WizardConfig.CONFIG_KEY("apiMode"))).ifPresent(a -> config.apiMode((String)a));
        Optional.ofNullable(realm.getAttribute(WizardConfig.CONFIG_KEY("enableGroupMapping"))).ifPresent(a -> config.enableGroupMapping(a.toLowerCase().equals("true")));
        Optional.ofNullable(realm.getAttribute(WizardConfig.CONFIG_KEY("enableLdap"))).ifPresent(a -> config.enableLdap(a.toLowerCase().equals("true")));
        Optional.ofNullable(realm.getAttribute(WizardConfig.CONFIG_KEY("enableDashboard"))).ifPresent(a -> config.enableDashboard(a.toLowerCase().equals("true")));
        Optional.ofNullable(realm.getAttribute(WizardConfig.CONFIG_KEY("emailAsUsername"))).ifPresent(a -> config.emailAsUsername(a.toLowerCase().equals("true")));
        Optional.ofNullable(realm.getAttribute(WizardConfig.CONFIG_KEY("trustEmail"))).ifPresent(a -> config.trustEmail(a.toLowerCase().equals("true")));
        Optional.ofNullable(realm.getAttribute(WizardConfig.CONFIG_KEY("usernameMapperImport"))).ifPresent(a -> config.usernameMapperImport(a.toLowerCase().equals("true")));
        Optional.ofNullable(realm.getAttribute(String.format("_providerConfig.assets.logo.url", new Object[0]))).ifPresent(a -> config.logoUrl((String)a));
        Optional.ofNullable(realm.getName()).ifPresent(a -> config.name((String)a));
        Optional.ofNullable(realm.getDisplayName()).ifPresent(a -> config.displayName((String)a));
        if (uri != null) {
            Optional.ofNullable(uri.getHost()).ifPresent(a -> config.domain((String)a));
        }
        return config;
    }

    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public WizardConfig domain(String domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public WizardConfig name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public WizardConfig displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="logoUrl")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @JsonProperty(value="logoUrl")
    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public WizardConfig logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @JsonProperty(value="apiMode")
    public String getApiMode() {
        return this.apiMode;
    }

    @JsonProperty(value="apiMode")
    public void setApiMode(String apiMode) {
        this.apiMode = apiMode;
    }

    public WizardConfig apiMode(String apiMode) {
        this.apiMode = apiMode;
        return this;
    }

    @JsonProperty(value="enableGroupMapping")
    public boolean getEnableGroupMapping() {
        return this.enableGroupMapping;
    }

    @JsonProperty(value="enableGroupMapping")
    public void setEnableGroupMapping(boolean enableGroupMapping) {
        this.enableGroupMapping = enableGroupMapping;
    }

    public WizardConfig enableGroupMapping(boolean enableGroupMapping) {
        this.enableGroupMapping = enableGroupMapping;
        return this;
    }

    @JsonProperty(value="enableLdap")
    public boolean getEnableLdap() {
        return this.enableLdap;
    }

    @JsonProperty(value="enableLdap")
    public void setEnableLdap(boolean enableLdap) {
        this.enableLdap = enableLdap;
    }

    public WizardConfig enableLdap(boolean enableLdap) {
        this.enableLdap = enableLdap;
        return this;
    }

    @JsonProperty(value="enableDashboard")
    public boolean getEnableDashboard() {
        return this.enableDashboard;
    }

    @JsonProperty(value="enableDashboard")
    public void setEnableDashboard(boolean enableDashboard) {
        this.enableDashboard = enableDashboard;
    }

    public WizardConfig enableDashboard(boolean enableDashboard) {
        this.enableDashboard = enableDashboard;
        return this;
    }

    @JsonProperty(value="emailAsUsername")
    public boolean getEmailAsUsername() {
        return this.emailAsUsername;
    }

    @JsonProperty(value="emailAsUsername")
    public void setEmailAsUsername(boolean emailAsUsername) {
        this.emailAsUsername = emailAsUsername;
    }

    public WizardConfig emailAsUsername(boolean emailAsUsername) {
        this.emailAsUsername = emailAsUsername;
        return this;
    }

    @JsonProperty(value="trustEmail")
    public boolean getTrustEmail() {
        return this.trustEmail;
    }

    @JsonProperty(value="trustEmail")
    public void setTrustEmail(boolean trustEmail) {
        this.trustEmail = trustEmail;
    }

    public WizardConfig trustEmail(boolean trustEmail) {
        this.trustEmail = trustEmail;
        return this;
    }

    @JsonProperty(value="usernameMapperImport")
    public boolean getUsernameMapperImport() {
        return this.usernameMapperImport;
    }

    @JsonProperty(value="usernameMapperImport")
    public void setUsernameMapperImport(boolean usernameMapperImport) {
        this.usernameMapperImport = usernameMapperImport;
    }

    public WizardConfig usernameMapperImport(boolean usernameMapperImport) {
        this.usernameMapperImport = usernameMapperImport;
        return this;
    }
}

