/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.wizard;

import com.google.common.collect.ImmutableMap;
import io.phasetwo.wizard.WizardConfig;
import jakarta.activation.MimetypesFileTypeMap;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.FreeMarkerLoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.theme.Theme;

public class WizardResourceProvider
implements RealmResourceProvider {
    private static final Logger log = Logger.getLogger(WizardResourceProvider.class);
    private final KeycloakSession session;
    private final String authRealmOverride;
    public static final String[] METHODS = new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"};
    private static final String MIME_TYPES = "text/javascript js\ntext/css css\nfont/woff woff\nfont/woff2 woff2\napplication/json json webmanifest map\nimage/svg+xml svg\n";

    public WizardResourceProvider(KeycloakSession session, String authRealmOverride) {
        this.session = session;
        this.authRealmOverride = authRealmOverride;
    }

    public Object getResource() {
        return this;
    }

    private void setupCors() {
        Cors.builder().allowAllOrigins().allowedMethods(METHODS).auth().add();
    }

    @OPTIONS
    @Path(value="{any:.*}")
    public Response preflight() {
        log.trace((Object)"CORS OPTIONS preflight request");
        return Cors.builder().auth().allowedMethods(METHODS).preflight().add(Response.ok());
    }

    @GET
    @Path(value="{path:.+}")
    public Response router(@PathParam(value="path") String path) throws Exception {
        Response response;
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        log.tracef("param path %s", (Object)path);
        log.tracef("absolutePath %s", (Object)uriInfo.getAbsolutePath());
        log.tracef("path %s", (Object)uriInfo.getPath());
        log.tracef("baseUri %s", (Object)uriInfo.getBaseUri());
        log.tracef("segments %s", (Object)uriInfo.getPathSegments());
        log.tracef("requestUri %s", (Object)uriInfo.getRequestUri());
        if (path == null || "".equals(path) || "/".equals(path)) {
            return this.wizard();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (Pattern.matches("^(200|fonts|images|main|site).*", path) && (response = this.staticResources(path)) != null) {
            log.tracef("returning response %d for path %s", response.getStatus(), (Object)path);
            return response;
        }
        return this.wizard();
    }

    @GET
    @Produces(value={"text/html"})
    public Response wizard() {
        log.trace((Object)"wizard index file");
        String wizardResources = ".";
        Theme theme = this.getTheme("wizard");
        RealmModel realm = this.session.getContext().getRealm();
        LoginFormsProvider form = ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAttribute("wizardResources", (Object)wizardResources).setAttribute("realmName", (Object)realm.getName());
        FreeMarkerLoginFormsProvider fm = (FreeMarkerLoginFormsProvider)form;
        try {
            Method processTemplateMethod = fm.getClass().getDeclaredMethod("processTemplate", Theme.class, String.class, Locale.class);
            processTemplateMethod.setAccessible(true);
            Response resp = (Response)processTemplateMethod.invoke((Object)fm, theme, "wizard.ftl", this.session.getContext().resolveLocale(null));
            return resp;
        }
        catch (Exception e) {
            log.warn((Object)"Could not call processTemplate on FreeMarkerLoginFormsProvider", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="{path:^(200|fonts|images|main|site).*}")
    public Response staticResources(@PathParam(value="path") String path) throws IOException {
        log.trace((Object)"static resources");
        String fileName = this.getLastPathSegment((UriInfo)this.session.getContext().getUri());
        Theme theme = this.getTheme("wizard");
        InputStream resource = theme.getResourceAsStream(path);
        String mimeType = this.getMimeType(fileName);
        log.tracef("%s [%s] (%s)", (Object)path, (Object)mimeType, (Object)(null == resource ? "404" : "200"));
        return null == resource ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok((Object)resource, (String)mimeType).build();
    }

    @GET
    @Path(value="keycloak.json")
    @Produces(value={"application/json"})
    public Response keycloakJson() {
        log.trace((Object)"keycloak.json");
        this.setupCors();
        RealmModel realm = this.session.getContext().getRealm();
        KeycloakUriInfo uriInfo = this.session.getContext().getUri();
        ImmutableMap json = ImmutableMap.of((Object)"realm", (Object)this.authRealmOverride, (Object)"auth-server-url", (Object)WizardResourceProvider.getBaseUrl((UriInfo)uriInfo), (Object)"resource", (Object)"idp-wizard");
        return Response.ok((Object)json).build();
    }

    @GET
    @Path(value="config.json")
    @Produces(value={"application/json"})
    public WizardConfig configJson() {
        log.trace((Object)"config.json");
        this.setupCors();
        return WizardConfig.createFromAttributes(this.session);
    }

    private static String getBaseUrl(UriInfo uriInfo) {
        String u = uriInfo.getBaseUri().toString();
        if (u != null && u.endsWith("/")) {
            u = u.substring(0, u.length() - 1);
        }
        return u;
    }

    private static String getOrigin(UriInfo uriInfo) {
        return uriInfo.getBaseUri().resolve("/").toString();
    }

    private Theme getTheme(String name) {
        try {
            return this.session.theme().getTheme(name, Theme.Type.LOGIN);
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getLastPathSegment(UriInfo uriInfo) {
        List segs = uriInfo.getPathSegments();
        if (segs != null && segs.size() > 0) {
            return ((PathSegment)segs.get(segs.size() - 1)).getPath();
        }
        return null;
    }

    private String getMimeType(String fileName) {
        MimetypesFileTypeMap map = new MimetypesFileTypeMap();
        map.addMimeTypes(MIME_TYPES);
        return map.getContentType(fileName);
    }

    public void close() {
    }
}

