/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.wizard;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.phasetwo.wizard.WizardResourceProvider;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;

@AutoService(value={RealmResourceProviderFactory.class})
public class WizardResourceProviderFactory
implements RealmResourceProviderFactory {
    private static final Logger log = Logger.getLogger(WizardResourceProviderFactory.class);
    public static final String ID = "wizard";
    public static final String NAME = "IdP Config Wizard";
    public static final String DESCRIPTION = "Wizards for configuring various vendor IdPs.";
    public static final String AUTH_REALM_OVERRIDE_CONFIG_KEY = "_providerConfig.wizard.auth-realm-override";

    public String getId() {
        return ID;
    }

    public RealmResourceProvider create(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        String override = Optional.ofNullable(realm.getAttribute(AUTH_REALM_OVERRIDE_CONFIG_KEY)).orElse(realm.getName());
        if (!override.equals(realm.getName())) {
            log.debugf("Using override realm %s", (Object)override);
        }
        return new WizardResourceProvider(session, override);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RealmModel.RealmPostCreateEvent) {
                log.debug((Object)"RealmPostCreateEvent");
                this.realmPostCreate((RealmModel.RealmPostCreateEvent)event);
            }
        });
    }

    private void initClients(KeycloakSession session) {
        try {
            session.realms().getRealmsStream().forEach(realm -> this.createClient((RealmModel)realm, session));
        }
        catch (Exception e) {
            log.warnf("Error initializing idp-wizard clients. Ignoring. You may have to create them manually. %s", (Object)e.getMessage());
        }
    }

    private void realmPostCreate(RealmModel.RealmPostCreateEvent event) {
        RealmModel realm = event.getCreatedRealm();
        KeycloakSession session = event.getKeycloakSession();
        this.createClient(realm, session);
    }

    private void createClient(RealmModel realm, KeycloakSession session) {
        log.debugf("Creating %s realm idp-wizard client.", (Object)realm.getName());
        ClientModel idpWizard = session.clients().getClientByClientId(realm, "idp-wizard");
        if (idpWizard == null) {
            log.debugf("No idp-wizard client for %s realm. Creating...", (Object)realm.getName());
            idpWizard = "master".equals(realm.getName()) ? this.createClientForMaster(realm, session) : this.createClientForRealm(realm, session);
        }
        this.setClientScopeDefaults(realm, session, idpWizard);
    }

    private String getRedirectPath(RealmModel realm) {
        return String.format("/realms/%s/%s/", realm.getName(), ID);
    }

    private ClientModel createClientForRealm(RealmModel realm, KeycloakSession session) {
        String path = this.getRedirectPath(realm);
        ClientModel idpWizard = session.clients().addClient(realm, "idp-wizard");
        this.setDefaults(realm, idpWizard);
        idpWizard.setRedirectUris((Set)ImmutableSet.of((Object)String.format("%s*", path)));
        idpWizard.setWebOrigins((Set)ImmutableSet.of((Object)"/*"));
        idpWizard.setAttribute("post.logout.redirect.uris", "+");
        return idpWizard;
    }

    private ClientModel createClientForMaster(RealmModel realm, KeycloakSession session) {
        ClientModel idpWizard = session.clients().addClient(realm, "idp-wizard");
        this.setDefaults(realm, idpWizard);
        idpWizard.setRedirectUris((Set)ImmutableSet.of((Object)"/*"));
        idpWizard.setWebOrigins((Set)ImmutableSet.of((Object)"/*"));
        idpWizard.setAttribute("post.logout.redirect.uris", "+");
        return idpWizard;
    }

    private void setDefaults(RealmModel realm, ClientModel idpWizard) {
        idpWizard.setProtocol("openid-connect");
        idpWizard.setPublicClient(true);
        idpWizard.setRootUrl("${authBaseUrl}");
        idpWizard.setName(NAME);
        idpWizard.setDescription(DESCRIPTION);
        idpWizard.setBaseUrl(this.getRedirectPath(realm));
    }

    private void setOrganizationRoleMapper(ClientModel idpWizard) {
        ProtocolMapperModel pro = idpWizard.getProtocolMapperByName("openid-connect", "organizations");
        if (pro != null) {
            return;
        }
        pro = new ProtocolMapperModel();
        pro.setProtocolMapper("oidc-organization-role-mapper");
        pro.setProtocol("openid-connect");
        pro.setName("organizations");
        ImmutableMap config = new ImmutableMap.Builder().put((Object)"id.token.claim", (Object)"true").put((Object)"access.token.claim", (Object)"true").put((Object)"claim.name", (Object)"organizations").put((Object)"jsonType.label", (Object)"JSON").put((Object)"userinfo.token.claim", (Object)"true").build();
        pro.setConfig((Map)config);
        idpWizard.addProtocolMapper(pro);
    }

    private void setOrganizationIdMapper(ClientModel idpWizard) {
        ProtocolMapperModel pro = idpWizard.getProtocolMapperByName("openid-connect", "org_id");
        if (pro != null) {
            return;
        }
        pro = new ProtocolMapperModel();
        pro.setProtocolMapper("oidc-usersessionmodel-note-mapper");
        pro.setProtocol("openid-connect");
        pro.setName("org_id");
        ImmutableMap config = new ImmutableMap.Builder().put((Object)"user.session.note", (Object)"org_id").put((Object)"id.token.claim", (Object)"true").put((Object)"access.token.claim", (Object)"true").put((Object)"claim.name", (Object)"org_id").put((Object)"jsonType.label", (Object)"String").put((Object)"userinfo.token.claim", (Object)"true").build();
        pro.setConfig((Map)config);
        idpWizard.addProtocolMapper(pro);
    }

    private void setClientScopeDefaults(RealmModel realm, KeycloakSession session, ClientModel idpWizard) {
        idpWizard.setFullScopeAllowed(true);
        session.clientScopes().getClientScopesStream(realm).filter(c -> c.getRealm().equals((Object)realm) && c.getName().equals("roles")).forEach(c -> {
            log.debugf("Found 'roles' client scope. Adding as default...", new Object[0]);
            try {
                idpWizard.addClientScope(c, true);
            }
            catch (Exception e) {
                log.warn((Object)"'roles' client scope already exists. skipping...");
            }
        });
        this.setOrganizationRoleMapper(idpWizard);
        this.setOrganizationIdMapper(idpWizard);
    }

    public void close() {
    }
}

