/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import io.piano.analytics.BuiltModel;
import io.piano.analytics.Configuration;
import io.piano.analytics.Event;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.WorkingQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

final class BuildStep
implements WorkingQueue.IStep {
    private static BuildStep instance = null;
    private static final String REQUEST_URI_DOMAIN_FORMAT = "https://%s";
    private static final String REQUEST_URI_QUERY_FORMAT = "%s?s=%s&idclient=%s";
    private static final String EVENTS_FIELD = "events";
    private static final String CONTEXT_FIELD = "context";

    static BuildStep getInstance() {
        if (instance == null) {
            instance = new BuildStep();
        }
        return instance;
    }

    private BuildStep() {
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        Configuration configuration = m.getConfiguration();
        Map<String, Object> contextProperties = m.getContextProperties();
        List<Event> events = m.getEvents();
        Configuration.OfflineStorageMode offlineMode = Configuration.OfflineStorageMode.fromString(configuration.get(Configuration.ConfigurationKey.OFFLINE_STORAGE_MODE));
        boolean mustBeSaved = false;
        if (offlineMode == Configuration.OfflineStorageMode.ALWAYS || offlineMode == Configuration.OfflineStorageMode.REQUIRED && PianoAnalyticsUtils.getConnection(ctx) == PianoAnalyticsUtils.ConnectionType.OFFLINE) {
            for (Event event : events) {
                event.getData().put("connection_type", PianoAnalyticsUtils.ConnectionType.OFFLINE.stringValue());
            }
            mustBeSaved = true;
        }
        JSONArray serializedEvents = new JSONArray();
        for (Event e : events) {
            serializedEvents.put((Object)new JSONObject(e.toMap()));
        }
        LinkedHashMap<String, JSONArray> linkedHashMap = new LinkedHashMap<String, JSONArray>();
        linkedHashMap.put(EVENTS_FIELD, serializedEvents);
        String visitorId = configuration.get(Configuration.ConfigurationKey.VISITOR_ID);
        try {
            URL domain = new URL(String.format(REQUEST_URI_DOMAIN_FORMAT, configuration.get(Configuration.ConfigurationKey.COLLECT_DOMAIN)));
            URL url = new URL(domain, String.format(REQUEST_URI_QUERY_FORMAT, configuration.get(Configuration.ConfigurationKey.PATH), configuration.get(Configuration.ConfigurationKey.SITE), PianoAnalyticsUtils.isEmptyString(visitorId) ? "" : visitorId));
            m.setBuiltModel(new BuiltModel(url.toString(), new JSONObject(linkedHashMap).toString(), mustBeSaved));
        }
        catch (MalformedURLException e) {
            PianoAnalytics.InternalLogger.severe("error on build step processTrackEvents: " + e.toString());
            return false;
        }
        return true;
    }
}

