/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import java.util.HashMap;
import java.util.Map;

final class CastUtils {
    CastUtils() {
    }

    static int toInt(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return ((Double)o).intValue();
        }
        try {
            return Double.valueOf(CastUtils.toString(o)).intValue();
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    static String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return String.valueOf(o);
    }

    static double toDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        try {
            return Double.parseDouble(CastUtils.toString(o));
        }
        catch (NumberFormatException ignored) {
            return 0.0;
        }
    }

    static boolean toBool(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(CastUtils.toString(o));
    }

    public static <K, V> Map<K, V> toMap(Class<? extends K> keyClass, Class<? extends V> valueClass, Map<?, ?> rawMap) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<?, ?> entry : rawMap.entrySet()) {
            try {
                result.put(keyClass.cast(entry.getKey()), valueClass.cast(entry.getValue()));
            }
            catch (ClassCastException classCastException) {}
        }
        return result;
    }
}

