/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import io.piano.analytics.CastUtils;
import io.piano.analytics.PianoAnalytics;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Configuration
extends HashMap<String, Object> {
    static final String DEFAULT_COLLECT_DOMAIN = "";
    static final String DEFAULT_PATH = "/event";
    static final String PRIVACY_DEFAULT_MODE = PianoAnalytics.PrivacyVisitorMode.OPTIN.stringValue();
    static final int DEFAULT_SITE = 0;
    static final int DEFAULT_SESSION_BACKGROUND_DURATION = 30;
    static final int DEFAULT_STORAGE_LIFETIME_PRIVACY = 395;
    static final int DEFAULT_STORAGE_LIFETIME_VISITOR = 395;
    static final int DEFAULT_STORAGE_LIFETIME_USER = 395;
    static final boolean DEFAULT_IGNORE_LIMITED_ADVERTISING_TRACKING = false;
    static final boolean DEFAULT_CRASH_DETECTION = true;
    static final boolean DEFAULT_SEND_WHEN_OPT_OUT = true;
    static final OfflineStorageMode DEFAULT_OFFLINE_STORAGE_MODE = OfflineStorageMode.NEVER;
    static final VisitorStorageMode DEFAULT_VISITOR_STORAGE_MODE = VisitorStorageMode.FIXED;
    static final VisitorIDType DEFAULT_VISITOR_ID_TYPE = VisitorIDType.UUID;
    static final EncryptionMode DEFAULT_ENCRYPTION_MODE = EncryptionMode.IF_COMPATIBLE;
    private final Set<String> rootProperties = new HashSet<String>(Arrays.asList(ConfigurationKey.COLLECT_DOMAIN.stringValue(), ConfigurationKey.PATH.stringValue(), ConfigurationKey.SITE.stringValue(), ConfigurationKey.VISITOR_ID.stringValue(), ConfigurationKey.VISITOR_ID_TYPE.stringValue(), ConfigurationKey.CUSTOM_USER_AGENT.stringValue()));

    public String get(ConfigurationKey key) {
        return CastUtils.toString(this.get(key.stringValue()));
    }

    Configuration() {
    }

    Configuration(Map<String, Object> m) {
        if (m != null) {
            this.putAll(m);
        }
    }

    Configuration getRootConfiguration() {
        Configuration c = new Configuration();
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!this.rootProperties.contains(key)) continue;
            c.put(key, entry.getValue());
        }
        return c;
    }

    boolean containsKey(ConfigurationKey key) {
        return this.containsKey(key.stringValue());
    }

    void set(ConfigurationKey key, String value) {
        this.put(key.stringValue(), value);
    }

    public static class Builder {
        private final Map<String, Object> configuration = new HashMap<String, Object>();

        public Builder withCollectDomain(String collectDomain) {
            return this.set(ConfigurationKey.COLLECT_DOMAIN, collectDomain);
        }

        public Builder withSite(int site) {
            return this.set(ConfigurationKey.SITE, site);
        }

        public Builder withPath(String path) {
            return this.set(ConfigurationKey.PATH, path);
        }

        public Builder withPrivacyDefaultMode(String mode) {
            return this.set(ConfigurationKey.PRIVACY_DEFAULT_MODE, mode);
        }

        public Builder withVisitorIDType(VisitorIDType visitorIDType) {
            return this.set(ConfigurationKey.VISITOR_ID_TYPE, visitorIDType.stringValue());
        }

        public Builder withOfflineStorageMode(OfflineStorageMode offlineStorageMode) {
            return this.set(ConfigurationKey.OFFLINE_STORAGE_MODE, offlineStorageMode.stringValue());
        }

        public Builder enableIgnoreLimitedAdTracking(boolean enabled) {
            return this.set(ConfigurationKey.IGNORE_LIMITED_AD_TRACKING, enabled);
        }

        public Builder enableCrashDetection(boolean enabled) {
            return this.set(ConfigurationKey.CRASH_DETECTION, enabled);
        }

        public Builder withVisitorStorageMode(VisitorStorageMode visitorStorageMode) {
            return this.set(ConfigurationKey.VISITOR_STORAGE_MODE, visitorStorageMode.stringValue());
        }

        public Builder withStorageLifetimePrivacy(int storageLifetimePrivacy) {
            return this.set(ConfigurationKey.STORAGE_LIFETIME_PRIVACY, storageLifetimePrivacy);
        }

        public Builder withStorageLifetimeVisitor(int storageLifetimeVisitor) {
            return this.set(ConfigurationKey.STORAGE_LIFETIME_VISITOR, storageLifetimeVisitor);
        }

        public Builder withStorageLifetimeUser(int storageLifetimeUser) {
            return this.set(ConfigurationKey.STORAGE_LIFETIME_USER, storageLifetimeUser);
        }

        public Builder withEncryptionMode(EncryptionMode encryptionMode) {
            return this.set(ConfigurationKey.ENCRYPTION_MODE, encryptionMode.stringValue());
        }

        public Builder withSessionBackgroundDuration(int sessionBackgroundDuration) {
            return this.set(ConfigurationKey.SESSION_BACKGROUND_DURATION, sessionBackgroundDuration);
        }

        public Builder enableSendEventWhenOptOut(boolean sendEventWhenOptOut) {
            return this.set(ConfigurationKey.SEND_EVENT_WHEN_OPT_OUT, sendEventWhenOptOut);
        }

        public Builder withVisitorID(String visitorID) {
            return this.set(ConfigurationKey.VISITOR_ID, visitorID).withVisitorIDType(VisitorIDType.CUSTOM);
        }

        public Builder withCustomUserAgent(String customUserAgent) {
            return this.set(ConfigurationKey.CUSTOM_USER_AGENT, customUserAgent);
        }

        public Configuration build() {
            return new Configuration(this.configuration);
        }

        private Builder set(ConfigurationKey key, Object value) {
            this.configuration.put(key.stringValue(), CastUtils.toString(value));
            return this;
        }
    }

    public static enum EncryptionMode {
        NONE("none"),
        IF_COMPATIBLE("ifCompatible"),
        FORCE("force");

        private final String str;

        private EncryptionMode(String val) {
            this.str = val;
        }

        String stringValue() {
            return this.str;
        }

        public static EncryptionMode fromString(String s) {
            for (EncryptionMode v : EncryptionMode.values()) {
                if (!v.stringValue().equalsIgnoreCase(s)) continue;
                return v;
            }
            PianoAnalytics.InternalLogger.severe("EncryptionModeEnum.fromString : fallback on EncryptionModeEnum.NONE mode because requested value is unknown");
            return IF_COMPATIBLE;
        }
    }

    public static enum VisitorStorageMode {
        FIXED("fixed"),
        RELATIVE("relative");

        private final String str;

        private VisitorStorageMode(String val) {
            this.str = val;
        }

        String stringValue() {
            return this.str;
        }

        public static VisitorStorageMode fromString(String s) {
            for (VisitorStorageMode v : VisitorStorageMode.values()) {
                if (!v.stringValue().equalsIgnoreCase(s)) continue;
                return v;
            }
            PianoAnalytics.InternalLogger.severe("VisitorStorageModeEnum.fromString : fallback on VisitorStorageModeEnum.FIXED mode because requested value is unknown");
            return FIXED;
        }
    }

    public static enum OfflineStorageMode {
        ALWAYS("always"),
        REQUIRED("required"),
        NEVER("never");

        private final String str;

        private OfflineStorageMode(String val) {
            this.str = val;
        }

        String stringValue() {
            return this.str;
        }

        public static OfflineStorageMode fromString(String s) {
            for (OfflineStorageMode v : OfflineStorageMode.values()) {
                if (!v.stringValue().equalsIgnoreCase(s)) continue;
                return v;
            }
            PianoAnalytics.InternalLogger.severe("OfflineModeEnum.fromString : fallback on OfflineModeEnum.NEVER mode because requested value is unknown");
            return NEVER;
        }
    }

    public static enum VisitorIDType {
        ANDROID_ID("androidId"),
        ADVERTISING_ID("advertisingId"),
        GOOGLE_ADVERTISING_ID("googleAdvertisingId"),
        HUAWEI_OPEN_ADVERTISING_ID("huaweiOpenAdvertisingId"),
        UUID("uuid"),
        CUSTOM("custom");

        private final String str;

        private VisitorIDType(String val) {
            this.str = val;
        }

        String stringValue() {
            return this.str;
        }

        public static VisitorIDType fromString(String s) {
            for (VisitorIDType v : VisitorIDType.values()) {
                if (!v.stringValue().equalsIgnoreCase(s)) continue;
                return v;
            }
            PianoAnalytics.InternalLogger.severe("VisitorIDTypeEnum.fromString : requested value is unknown");
            return UUID;
        }
    }

    public static enum ConfigurationKey {
        COLLECT_DOMAIN("collectDomain"),
        SITE("site"),
        PATH("path"),
        PRIVACY_DEFAULT_MODE("privacyDefaultMode"),
        OFFLINE_STORAGE_MODE("offlineStorageMode"),
        IGNORE_LIMITED_AD_TRACKING("ignoreLimitedAdTracking"),
        CRASH_DETECTION("crashDetection"),
        VISITOR_STORAGE_MODE("visitorStorageMode"),
        STORAGE_LIFETIME_USER("storageLifetimeUser"),
        STORAGE_LIFETIME_PRIVACY("storageLifetimePrivacy"),
        STORAGE_LIFETIME_VISITOR("storageLifetimeVisitor"),
        SESSION_BACKGROUND_DURATION("sessionBackgroundDuration"),
        SEND_EVENT_WHEN_OPT_OUT("sendEventWhenOptOut"),
        ENCRYPTION_MODE("encryptionMode"),
        VISITOR_ID("visitorId"),
        VISITOR_ID_TYPE("visitorIdType"),
        CUSTOM_USER_AGENT("customUserAgent");

        private final String str;

        private ConfigurationKey(String val) {
            this.str = val;
        }

        String stringValue() {
            return this.str;
        }

        public static ConfigurationKey fromString(String s) {
            for (ConfigurationKey v : ConfigurationKey.values()) {
                if (!v.stringValue().equalsIgnoreCase(s)) continue;
                return v;
            }
            PianoAnalytics.InternalLogger.severe("ConfigurationKeysEnum.fromString : requested value is unknown");
            return null;
        }
    }
}

