/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.util.Pair;
import io.piano.analytics.Configuration;
import io.piano.analytics.MapUtils;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.WorkingQueue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class ConfigurationStep
implements WorkingQueue.IStep {
    private static ConfigurationStep instance = null;
    private Configuration configuration;
    private static final String USER_AGENT_SYSTEM_PROPERTY = "http.agent";
    private static final String USER_AGENT_FORMAT = "%s %s/%s";

    static ConfigurationStep getInstance(Context ctx, String configFileLocation) {
        if (instance == null) {
            instance = new ConfigurationStep(ctx, configFileLocation);
        }
        return instance;
    }

    private ConfigurationStep(Context ctx, String configFileLocation) {
        this.configuration = new Configuration.Builder().withCollectDomain("").withPath("/event").withPrivacyDefaultMode(Configuration.PRIVACY_DEFAULT_MODE).withSite(0).withOfflineStorageMode(Configuration.DEFAULT_OFFLINE_STORAGE_MODE).enableIgnoreLimitedAdTracking(false).enableCrashDetection(true).withVisitorIDType(Configuration.DEFAULT_VISITOR_ID_TYPE).withVisitorStorageMode(Configuration.DEFAULT_VISITOR_STORAGE_MODE).withStorageLifetimePrivacy(395).withStorageLifetimeVisitor(395).withStorageLifetimeUser(395).enableSendEventWhenOptOut(true).withEncryptionMode(Configuration.DEFAULT_ENCRYPTION_MODE).withSessionBackgroundDuration(30).withCustomUserAgent(this.getDefaultUserAgent(ctx)).build();
        if (!PianoAnalyticsUtils.isEmptyString(configFileLocation)) {
            this.loadConfigurationFromLocalFile(ctx, configFileLocation);
        }
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    ConfigurationStep setConfiguration(Configuration configuration) {
        this.configuration = new Configuration(configuration);
        return this;
    }

    private String getDefaultUserAgent(Context appContext) {
        ApplicationInfo applicationInfo = appContext.getApplicationInfo();
        Pair<String, String> appProps = PianoAnalyticsUtils.getApplicationProperties(appContext);
        String appName = applicationInfo.labelRes == 0 ? (applicationInfo.nonLocalizedLabel != null ? applicationInfo.nonLocalizedLabel.toString() : null) : appContext.getString(applicationInfo.labelRes);
        return String.format(USER_AGENT_FORMAT, System.getProperty(USER_AGENT_SYSTEM_PROPERTY), appName, appProps != null ? appProps.second : null);
    }

    void loadConfigurationFromLocalFile(Context ctx, String configFileLocation) {
        Map<Object, Object> objectMap;
        try {
            objectMap = MapUtils.fromJSONString(PianoAnalyticsUtils.getStringFromInputStream(ctx.getAssets().open(configFileLocation)));
        }
        catch (IOException e) {
            objectMap = new HashMap();
        }
        for (Map.Entry<Object, Object> entry : objectMap.entrySet()) {
            String key = (String)entry.getKey();
            Configuration.ConfigurationKey enumKey = Configuration.ConfigurationKey.fromString(key);
            if (enumKey == null) continue;
            this.configuration.put(enumKey.stringValue(), entry.getValue());
        }
    }

    private Configuration merge(Configuration customConf) {
        Configuration merged = new Configuration(this.configuration);
        merged.putAll(customConf);
        return merged;
    }

    @Override
    public void processGetModel(Context ctx, Model m) {
        m.Config(new Configuration(this.configuration));
    }

    @Override
    public void processUpdateContext(Model m) {
        m.Config(new Configuration(this.configuration));
    }

    @Override
    public void processSetConfig(Model m) {
        Configuration conf = m.getConfiguration();
        this.configuration.putAll(conf);
        m.Config(new Configuration(this.configuration));
    }

    @Override
    public void processGetConfig(Model m) {
        m.Config(new Configuration(this.configuration));
    }

    @Override
    public boolean processSendOfflineStorage(Model m, PianoAnalytics.OnWorkListener l) {
        Configuration customConf = m.getConfiguration();
        m.Config(this.merge(customConf));
        return true;
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        Configuration customConf = m.getConfiguration();
        m.Config(this.merge(customConf));
        return true;
    }
}

