/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.NonNull;
import io.piano.analytics.CastUtils;
import io.piano.analytics.Configuration;
import io.piano.analytics.Event;
import io.piano.analytics.MapUtils;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PrivacyStep;
import io.piano.analytics.WorkingQueue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

final class CrashHandlingStep
implements WorkingQueue.IStep,
Thread.UncaughtExceptionHandler {
    private static CrashHandlingStep instance = null;
    private final SharedPreferences sharedPreferences;
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final String packageName;
    private final PrivacyStep privacyStep;
    private boolean isCrashHandlingRegistered;
    private String savedPageProperty = "";
    static final String APP_CRASH_PROPERTIES_FORMAT = "app_crash%s";
    private static final String PAGE_PROPERTY_KEY = "page";

    static CrashHandlingStep getInstance(Context ctx, PrivacyStep privacyStep) {
        if (instance == null) {
            instance = new CrashHandlingStep(ctx, privacyStep);
        }
        return instance;
    }

    private CrashHandlingStep(Context ctx, PrivacyStep privacyStep) {
        this.packageName = ctx.getPackageName();
        this.sharedPreferences = ctx.getSharedPreferences("PAPreferencesKey", 0);
        this.defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        this.privacyStep = privacyStep;
    }

    String getSavedPageProperty() {
        return this.savedPageProperty;
    }

    void setSavedPageProperty(String savedPageProperty) {
        this.savedPageProperty = savedPageProperty;
    }

    private Map<String, Object> getProperties(Context ctx) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SharedPreferences preferences = ctx.getSharedPreferences("PAPreferencesKey", 0);
        boolean crashed = preferences.getBoolean("PACrashed", false);
        if (!crashed) {
            return result;
        }
        preferences.edit().remove("PACrashed").apply();
        String crashInfo = preferences.getString("PACrashInfo", null);
        Map<String, Object> objectMap = MapUtils.fromJSONString(crashInfo);
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            String key = entry.getKey();
            result.put(key, entry.getValue());
        }
        return result;
    }

    private String getClassNameException(Throwable t) {
        for (StackTraceElement element : t.getStackTrace()) {
            if (!element.getClassName().contains(this.packageName)) continue;
            return element.getClassName();
        }
        return "";
    }

    @Override
    public void uncaughtException(@NonNull Thread t, @NonNull Throwable e) {
        String exceptionName;
        String className;
        Throwable cause = e.getCause();
        if (cause != null) {
            className = this.getClassNameException(cause);
            exceptionName = cause.getClass().getName();
        } else {
            className = this.getClassNameException(e);
            exceptionName = e.getClass().getName();
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(String.format(APP_CRASH_PROPERTIES_FORMAT, "_screen"), this.savedPageProperty);
        m.put(String.format(APP_CRASH_PROPERTIES_FORMAT, "_class"), className);
        m.put(String.format(APP_CRASH_PROPERTIES_FORMAT, ""), exceptionName);
        JSONObject jObject = new JSONObject(m);
        this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.CRASH, new Pair((Object)"PACrashed", (Object)true), new Pair((Object)"PACrashInfo", (Object)jObject.toString()));
        if (this.defaultHandler != null) {
            this.defaultHandler.uncaughtException(t, e);
        }
    }

    @Override
    public void processSetConfig(Model m) {
        boolean shouldNotBeRegistered;
        Configuration configuration = m.getConfiguration();
        boolean crashDetectionEnabled = CastUtils.toBool(configuration.get(Configuration.ConfigurationKey.CRASH_DETECTION));
        boolean shouldBeRegistered = crashDetectionEnabled && !this.isCrashHandlingRegistered;
        boolean bl = shouldNotBeRegistered = !crashDetectionEnabled && this.isCrashHandlingRegistered;
        if (shouldBeRegistered) {
            this.isCrashHandlingRegistered = true;
            Thread.setDefaultUncaughtExceptionHandler(this);
        } else if (shouldNotBeRegistered) {
            this.isCrashHandlingRegistered = false;
            Thread.setDefaultUncaughtExceptionHandler(this.defaultHandler);
        }
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        Object pageProperty;
        List<Event> events = m.getEvents();
        Event lastEvent = events.get(events.size() - 1);
        if (lastEvent != null && (pageProperty = lastEvent.getData().get(PAGE_PROPERTY_KEY)) != null) {
            this.savedPageProperty = CastUtils.toString(pageProperty);
        }
        m.addContextProperties(this.getProperties(ctx));
        return true;
    }
}

