/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import androidx.annotation.RequiresApi;
import io.piano.analytics.Configuration;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

final class Crypt {
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final String PROVIDER = "AndroidKeyStore";
    private static final String ALIAS = "pa.encryption.key";
    private static final int IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 128;

    private Crypt() {
    }

    @RequiresApi(api=23)
    private static SecretKey getKey() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, UnrecoverableEntryException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyStore.Entry keyEntry;
        KeyStore keyStore = KeyStore.getInstance(PROVIDER);
        keyStore.load(null);
        if (keyStore.containsAlias(ALIAS) && (keyEntry = keyStore.getEntry(ALIAS, null)) instanceof KeyStore.SecretKeyEntry) {
            return ((KeyStore.SecretKeyEntry)keyEntry).getSecretKey();
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", PROVIDER);
        keyGenerator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(ALIAS, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).build());
        return keyGenerator.generateKey();
    }

    static String encrypt(String data, Configuration.EncryptionMode encryptionMode) {
        if (PianoAnalyticsUtils.isEmptyString(data)) {
            return null;
        }
        if (encryptionMode == Configuration.EncryptionMode.NONE) {
            return data;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Cipher cipher = Cipher.getInstance(TRANSFORMATION);
                cipher.init(1, Crypt.getKey());
                byte[] iv = cipher.getIV();
                byte[] cipherText = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
                byte[] encrypted = new byte[iv.length + cipherText.length];
                System.arraycopy(iv, 0, encrypted, 0, iv.length);
                System.arraycopy(cipherText, 0, encrypted, iv.length, cipherText.length);
                return Base64.encodeToString((byte[])encrypted, (int)0);
            }
            catch (Exception e) {
                PianoAnalytics.InternalLogger.warning("error on Crypt.encrypt : " + e.toString());
            }
        }
        return encryptionMode == Configuration.EncryptionMode.IF_COMPATIBLE ? data : null;
    }

    static String decrypt(String data) {
        if (PianoAnalyticsUtils.isEmptyString(data)) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Cipher cipher = Cipher.getInstance(TRANSFORMATION);
                byte[] encryptedData = Base64.decode((String)data, (int)0);
                cipher.init(2, (Key)Crypt.getKey(), new GCMParameterSpec(128, encryptedData, 0, 12));
                return new String(cipher.doFinal(encryptedData, 12, encryptedData.length - 12), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                PianoAnalytics.InternalLogger.warning("error on Crypt.decrypt : " + e.toString());
            }
        }
        return data;
    }
}

