/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import io.piano.analytics.CustomerContextModel;
import io.piano.analytics.Event;
import io.piano.analytics.MapUtils;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.WorkingQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class CustomerContextPropertiesStep
implements WorkingQueue.IStep {
    private static CustomerContextPropertiesStep instance = null;
    private static final String allEventsNameWildcard = "*";
    private final List<ContextProperties> properties = new ArrayList<ContextProperties>();

    static CustomerContextPropertiesStep getInstance() {
        if (instance == null) {
            instance = new CustomerContextPropertiesStep();
        }
        return instance;
    }

    private CustomerContextPropertiesStep() {
    }

    CustomerContextPropertiesStep setProperties(Map<String, Object> properties) {
        return this.setProperties(properties, null);
    }

    CustomerContextPropertiesStep setProperties(Map<String, Object> properties, String[] events) {
        if (events == null || events.length == 0) {
            events = new String[]{allEventsNameWildcard};
        }
        this.properties.add(new ContextProperties(properties, true, events));
        return this;
    }

    List<ContextProperties> getProperties() {
        return this.properties;
    }

    @Override
    public void processUpdateContext(Model m) {
        CustomerContextModel customerContextModel = m.getCustomerContextModel();
        if (customerContextModel == null) {
            return;
        }
        Map<String, Object> props = customerContextModel.getProperties();
        String[] events = customerContextModel.getEvents();
        if (events == null || events.length == 0) {
            events = new String[]{allEventsNameWildcard};
        }
        Boolean persistent = customerContextModel.getPersistent();
        switch (customerContextModel.getUpdateRequestKey()) {
            case ADD: {
                this.properties.add(new ContextProperties(props, persistent, events));
                break;
            }
            case DELETE: {
                if (props == null) {
                    this.properties.clear();
                    break;
                }
                for (String key : props.keySet()) {
                    for (ContextProperties contextProperties : this.properties) {
                        contextProperties.data.remove(key);
                    }
                }
                break;
            }
            default: {
                PianoAnalytics.InternalLogger.warning("CustomerContextPropertiesStep.processUpdateContext : unknown update request key case");
            }
        }
    }

    @Override
    public void processGetModel(Context ctx, Model m) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (ContextProperties contextProperties : this.properties) {
            if (!Arrays.asList(contextProperties.events).contains(allEventsNameWildcard)) continue;
            for (Map.Entry<String, Object> entry : contextProperties.data.entrySet()) {
                if (context.containsKey(entry.getKey())) continue;
                context.put(entry.getKey(), entry.getValue());
            }
        }
        m.addContextProperties(context);
    }

    List<Event> addPropertiesFromContext(List<Event> events, ContextProperties contextProperties) {
        ArrayList<Event> newEvents = new ArrayList<Event>(events.size());
        for (Event event : events) {
            Map<String, Object> newEventData = MapUtils.copy((Map)event.toMap().get("data"));
            if (PianoAnalyticsUtils.simpleWildcardCompare(contextProperties.events, event.getName())) {
                for (Map.Entry<String, Object> entry : contextProperties.data.entrySet()) {
                    if (newEventData.containsKey(entry.getKey())) continue;
                    newEventData.put(entry.getKey(), entry.getValue());
                }
            }
            newEvents.add(new Event(event.getName(), newEventData));
        }
        return newEvents;
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        ArrayList<ContextProperties> persistentProperties = new ArrayList<ContextProperties>();
        for (ContextProperties contextProperties : this.properties) {
            if (PianoAnalyticsUtils.contains(contextProperties.events, allEventsNameWildcard)) {
                m.addContextProperties(contextProperties.data);
            } else {
                m.setEvents(this.addPropertiesFromContext(m.getEvents(), contextProperties));
            }
            if (!contextProperties.persistent.booleanValue()) continue;
            persistentProperties.add(contextProperties);
        }
        this.properties.clear();
        this.properties.addAll(persistentProperties);
        return true;
    }

    class ContextProperties {
        Map<String, Object> data;
        Boolean persistent;
        String[] events;

        ContextProperties(Map<String, Object> data, Boolean persistent, String[] events) {
            this.data = data;
            this.persistent = persistent;
            this.events = events;
        }
    }
}

