/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.view.Display;
import android.view.WindowManager;
import io.piano.analytics.CastUtils;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.WorkingQueue;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

final class InternalContextPropertiesStep
implements WorkingQueue.IStep {
    private static InternalContextPropertiesStep instance = null;
    static final String DEVICE_TIMESTAMP_UTC_PROPERTY = "device_timestamp_utc";
    static final String CONNECTION_TYPE_PROPERTY = "connection_type";
    static final String DEVICE_SCREEN_PROPERTIES_FORMAT = "device_screen%s";
    static final String DEVICE_SCREEN_DIAGONAL_PROPERTY = String.format("device_screen%s", "_diagonal");
    static final String APP_VERSION_PROPERTY = "app_version";
    static final String MANUFACTURER_PROPERTY = "device_manufacturer";
    static final String MODEL_PROPERTY = "device_model";
    static final String OS_PROPERTIES_FORMAT = "os_%s";
    static final String EVENT_COLLECTION_PROPERTIES_FORMAT = "event_collection_%s";
    static final String BROWSER_LANGUAGE_PROPERTIES = "browser_language";
    static final String BROWSER_LANGUAGE_LOCALE_PROPERTIES = "browser_language_local";
    private static final String PLATFORM = "android";
    private boolean displayingCached;
    private final Map<String, Object> displayingProperties = new HashMap<String, Object>();
    private final IInternalContextPropertiesFunction getDisplayingProperties = ctx -> {
        int heightPixels;
        int widthPixels;
        if (this.displayingCached) {
            return this.displayingProperties;
        }
        Display d = ((WindowManager)ctx.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        d.getMetrics(displayMetrics);
        if (Build.VERSION.SDK_INT >= 17) {
            Point realSize = new Point();
            d.getRealSize(realSize);
            widthPixels = realSize.x;
            heightPixels = realSize.y;
        } else {
            try {
                Object rawWidth = Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)d, new Object[0]);
                Object rawHeight = Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)d, new Object[0]);
                widthPixels = rawWidth != null ? (Integer)rawWidth : 0;
                heightPixels = rawHeight != null ? (Integer)rawHeight : 0;
            }
            catch (Exception e) {
                PianoAnalytics.InternalLogger.severe("error on InternalContextPropertiesStep.getDisplayingProperties : " + e.toString());
                widthPixels = displayMetrics.widthPixels;
                heightPixels = displayMetrics.heightPixels;
            }
        }
        double x = Math.pow((float)widthPixels / displayMetrics.xdpi, 2.0);
        double y = Math.pow((float)heightPixels / displayMetrics.ydpi, 2.0);
        this.displayingProperties.put(String.format(DEVICE_SCREEN_PROPERTIES_FORMAT, "_width"), displayMetrics.widthPixels);
        this.displayingProperties.put(String.format(DEVICE_SCREEN_PROPERTIES_FORMAT, "_height"), displayMetrics.heightPixels);
        this.displayingProperties.put(DEVICE_SCREEN_DIAGONAL_PROPERTY, CastUtils.toDouble(new DecimalFormat("##.#").format(Math.sqrt(x + y))));
        this.displayingCached = true;
        return this.displayingProperties;
    };
    private boolean applicationCached;
    private final Map<String, Object> applicationProperties = new HashMap<String, Object>();
    private final IInternalContextPropertiesFunction getApplicationProperties = ctx -> {
        if (this.applicationCached) {
            return this.applicationProperties;
        }
        Pair<String, String> appProps = PianoAnalyticsUtils.getApplicationProperties(ctx);
        if (appProps != null) {
            this.applicationProperties.put("app_id", appProps.first);
            this.applicationProperties.put(APP_VERSION_PROPERTY, appProps.second);
            this.applicationCached = true;
        }
        return this.applicationProperties;
    };
    private static final String OS_NAME = String.format("%s %s", "android", Build.VERSION.RELEASE);
    private boolean hardwareCached;
    private final Map<String, Object> hardwareProperties = new HashMap<String, Object>();
    private final IInternalContextPropertiesFunction getHardwareProperties = ctx -> {
        if (this.hardwareCached) {
            return this.hardwareProperties;
        }
        this.hardwareProperties.put(String.format(OS_PROPERTIES_FORMAT, "group"), PLATFORM);
        this.hardwareProperties.put(String.format(OS_PROPERTIES_FORMAT, "version"), Build.VERSION.RELEASE);
        this.hardwareProperties.put("os", OS_NAME);
        this.hardwareProperties.put(MANUFACTURER_PROPERTY, Build.MANUFACTURER);
        this.hardwareProperties.put(MODEL_PROPERTY, Build.MODEL);
        this.hardwareCached = true;
        return this.hardwareProperties;
    };
    private static final String BROWSER_LANGUAGE_LOCAL_FORMAT = "%s-%s";
    private final IInternalContextPropertiesFunction getLocaleProperties = ctx -> {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Locale localeDefault = Locale.getDefault();
        String localeLanguage = localeDefault.toString();
        if (localeLanguage.contains("_")) {
            localeLanguage = localeLanguage.substring(localeLanguage.indexOf("_") + 1);
        }
        m.put(DEVICE_TIMESTAMP_UTC_PROPERTY, PianoAnalyticsUtils.currentTimeMillis() / 1000L);
        m.put(BROWSER_LANGUAGE_PROPERTIES, localeDefault.getLanguage());
        m.put(BROWSER_LANGUAGE_LOCALE_PROPERTIES, localeLanguage);
        m.put(CONNECTION_TYPE_PROPERTY, PianoAnalyticsUtils.getConnection(ctx).stringValue());
        return m;
    };
    private static final String EVENT_COLLECTION_VERSION = "3.2.1";
    private boolean tagCached;
    private final Map<String, Object> tagProperties = new HashMap<String, Object>();
    private final IInternalContextPropertiesFunction getTagProperties = ctx -> {
        if (this.tagCached) {
            return this.tagProperties;
        }
        this.tagProperties.put(String.format(EVENT_COLLECTION_PROPERTIES_FORMAT, "platform"), PLATFORM);
        this.tagProperties.put(String.format(EVENT_COLLECTION_PROPERTIES_FORMAT, "version"), EVENT_COLLECTION_VERSION);
        this.tagCached = true;
        return this.tagProperties;
    };
    private final IInternalContextPropertiesFunction[] propertiesFunctions = new IInternalContextPropertiesFunction[]{this.getDisplayingProperties, this.getApplicationProperties, this.getHardwareProperties, this.getLocaleProperties, this.getTagProperties};

    static InternalContextPropertiesStep getInstance() {
        if (instance == null) {
            instance = new InternalContextPropertiesStep();
        }
        return instance;
    }

    private InternalContextPropertiesStep() {
    }

    private Map<String, Object> getProperties(Context ctx) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (IInternalContextPropertiesFunction f : this.propertiesFunctions) {
            m.putAll(f.getProperties(ctx));
        }
        return m;
    }

    @Override
    public void processGetModel(Context ctx, Model m) {
        m.addContextProperties(this.getProperties(ctx));
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        m.addContextProperties(this.getProperties(ctx));
        return true;
    }

    private static interface IInternalContextPropertiesFunction {
        public Map<String, Object> getProperties(Context var1);
    }
}

