/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.piano.analytics.CastUtils;
import io.piano.analytics.Configuration;
import io.piano.analytics.Model;
import io.piano.analytics.PianoAnalytics;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.PrivacyStep;
import io.piano.analytics.WorkingQueue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

final class LifecycleStep
implements WorkingQueue.IStep,
Application.ActivityLifecycleCallbacks {
    private static LifecycleStep instance = null;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
    private final PrivacyStep privacyStep;
    private String versionCode;
    private String sessionId;
    private int sessionBackgroundDuration;
    private long timestampBackgroundStarted = -1L;
    private final SharedPreferences sharedPreferences;
    private String savedActivityName;
    private int savedActivityTaskId;
    private static final int DEFAULT_SESSION_BACKGROUND_DURATION = 2;
    private final ILifecycleFunction daysSinceFirstSession = (preferences, editor, ps) -> {
        Date firstSessionDate;
        String firstSessionDateStr = preferences.getString("PAFirstLaunchDate", "");
        if (!PianoAnalyticsUtils.isEmptyString(firstSessionDateStr) && (firstSessionDate = this.dateFormatter.parse(firstSessionDateStr)) != null) {
            long timeSinceFirstSession = firstSessionDate.getTime();
            ps.storeData(editor, PianoAnalytics.PrivacyStorageFeature.LIFECYCLE, new Pair((Object)"PADaysSinceFirstLaunch", (Object)PianoAnalyticsUtils.convertMillisTo(TimeUnit.DAYS, Math.abs(PianoAnalyticsUtils.currentTimeMillis() - timeSinceFirstSession))));
        }
    };
    private final ILifecycleFunction daysSinceUpdate = (preferences, editor, ps) -> {
        Date firstSessionDateAfterUpdate;
        String firstSessionDateAfterUpdateStr = preferences.getString("PAFirstLaunchDateAfterUpdate", "");
        if (!PianoAnalyticsUtils.isEmptyString(firstSessionDateAfterUpdateStr) && (firstSessionDateAfterUpdate = this.dateFormatter.parse(firstSessionDateAfterUpdateStr)) != null) {
            long timeSinceFirstSessionAfterUpdate = firstSessionDateAfterUpdate.getTime();
            ps.storeData(editor, PianoAnalytics.PrivacyStorageFeature.LIFECYCLE, new Pair((Object)"PADaysSinceFirstLaunchAfterUpdate", (Object)PianoAnalyticsUtils.convertMillisTo(TimeUnit.DAYS, Math.abs(PianoAnalyticsUtils.currentTimeMillis() - timeSinceFirstSessionAfterUpdate))));
        }
    };
    private final ILifecycleFunction daysSinceLastSession = (preferences, editor, ps) -> {
        Date lastSessionDate;
        String lastSessionDateStr = preferences.getString("PALastLaunchDate", "");
        if (!PianoAnalyticsUtils.isEmptyString(lastSessionDateStr) && (lastSessionDate = this.dateFormatter.parse(lastSessionDateStr)) != null) {
            long timeSinceLastUse = lastSessionDate.getTime();
            ps.storeData(editor, PianoAnalytics.PrivacyStorageFeature.LIFECYCLE, new Pair((Object)"PADaysSinceLastUse", (Object)PianoAnalyticsUtils.convertMillisTo(TimeUnit.DAYS, Math.abs(PianoAnalyticsUtils.currentTimeMillis() - timeSinceLastUse))));
        }
    };
    private final ILifecycleFunction[] computingMetrics = new ILifecycleFunction[]{this.daysSinceFirstSession, this.daysSinceLastSession, this.daysSinceUpdate};

    static LifecycleStep getInstance(Context ctx, PrivacyStep privacyStep) {
        if (instance == null) {
            instance = new LifecycleStep(ctx, privacyStep);
        }
        return instance;
    }

    private LifecycleStep(Context ctx, PrivacyStep privacyStep) {
        this.privacyStep = privacyStep;
        try {
            this.versionCode = CastUtils.toString(ctx.getPackageManager().getPackageInfo((String)ctx.getApplicationContext().getPackageName(), (int)0).versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            PianoAnalytics.InternalLogger.severe("error on constructor LifecycleStep : " + e.toString());
            this.versionCode = "";
        }
        ((Application)ctx.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.sharedPreferences = ctx.getSharedPreferences("PAPreferencesKey", 0);
        this.sharedPreferences.edit().remove("PAInitLifecycleDone").apply();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void init() {
        if (!this.sharedPreferences.getBoolean("PAFirstLaunch", true) || this.sharedPreferences.getBoolean("PAFirstInitLifecycleDone", false)) {
            this.newSessionInit();
        } else {
            this.firstSessionInit();
            this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.LIFECYCLE, new Pair((Object)"PAFirstInitLifecycleDone", (Object)true));
        }
        this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.LIFECYCLE, new Pair((Object)"PAInitLifecycleDone", (Object)true));
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void firstSessionInit() {
        Date now = new Date(PianoAnalyticsUtils.currentTimeMillis());
        this.sessionId = UUID.randomUUID().toString();
        this.privacyStep.storeData(this.sharedPreferences.edit(), PianoAnalytics.PrivacyStorageFeature.LIFECYCLE, new Pair((Object)"PAFirstLaunch", (Object)true), new Pair((Object)"PAFirstLaunchAfterUpdate", (Object)false), new Pair((Object)"PALaunchCount", (Object)1), new Pair((Object)"PALaunchCountSinceUpdate", (Object)1), new Pair((Object)"PADaysSinceFirstLaunch", (Object)0), new Pair((Object)"PADaysSinceLastUse", (Object)0), new Pair((Object)"PAFirstLaunchDate", (Object)this.dateFormatter.format(now)), new Pair((Object)"PALastLaunchDate", (Object)this.dateFormatter.format(now)), new Pair((Object)"PAVersionCode", (Object)this.versionCode));
    }

    private void newSessionInit() {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        try {
            for (ILifecycleFunction f : this.computingMetrics) {
                f.computeMetric(this.sharedPreferences, editor, this.privacyStep);
            }
            Date now = new Date(PianoAnalyticsUtils.currentTimeMillis());
            this.privacyStep.storeData(editor, PianoAnalytics.PrivacyStorageFeature.LIFECYCLE, new Pair((Object)"PAFirstLaunch", (Object)false), new Pair((Object)"PAFirstLaunchAfterUpdate", (Object)false), new Pair((Object)"PALastLaunchDate", (Object)this.dateFormatter.format(now)), new Pair((Object)"PALaunchCount", (Object)(this.sharedPreferences.getInt("PALaunchCount", 0) + 1)), new Pair((Object)"PALaunchCountSinceUpdate", (Object)(this.sharedPreferences.getInt("PALaunchCountSinceUpdate", 0) + 1)));
            String savedVersionCode = this.sharedPreferences.getString("PAVersionCode", null);
            if (!this.versionCode.equals(savedVersionCode)) {
                this.privacyStep.storeData(editor, PianoAnalytics.PrivacyStorageFeature.LIFECYCLE, new Pair((Object)"PAFirstLaunchDateAfterUpdate", (Object)this.dateFormatter.format(now)), new Pair((Object)"PAVersionCode", (Object)this.versionCode), new Pair((Object)"PALaunchCountSinceUpdate", (Object)1), new Pair((Object)"PADaysSinceFirstLaunchAfterUpdate", (Object)0), new Pair((Object)"PAFirstLaunchAfterUpdate", (Object)true));
            }
        }
        catch (ParseException e) {
            PianoAnalytics.InternalLogger.severe("error on LifecycleStep.newSessionInit : " + e.toString());
        }
        this.sessionId = UUID.randomUUID().toString();
    }

    private Map<String, Object> getProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (!this.sharedPreferences.getBoolean("PAInitLifecycleDone", false)) {
            this.init();
        }
        m.put("app_fs", this.sharedPreferences.getBoolean("PAFirstLaunch", false));
        m.put("app_fsau", this.sharedPreferences.getBoolean("PAFirstLaunchAfterUpdate", false));
        m.put("app_sc", this.sharedPreferences.getInt("PALaunchCount", 0));
        m.put("app_dsls", this.sharedPreferences.getInt("PADaysSinceLastUse", 0));
        m.put("app_dsfs", this.sharedPreferences.getInt("PADaysSinceFirstLaunch", 0));
        m.put("app_fsd", Integer.parseInt(this.sharedPreferences.getString("PAFirstLaunchDate", this.dateFormatter.format(new Date(PianoAnalyticsUtils.currentTimeMillis())))));
        m.put("app_sessionid", this.sessionId);
        if (!PianoAnalyticsUtils.isEmptyString(this.sharedPreferences.getString("PAFirstLaunchDateAfterUpdate", ""))) {
            m.put("app_scsu", this.sharedPreferences.getInt("PALaunchCountSinceUpdate", 0));
            m.put("app_fsdau", Integer.parseInt(this.sharedPreferences.getString("PAFirstLaunchDateAfterUpdate", this.dateFormatter.format(new Date(PianoAnalyticsUtils.currentTimeMillis())))));
            m.put("app_dsu", this.sharedPreferences.getInt("PADaysSinceFirstLaunchAfterUpdate", 0));
        }
        return m;
    }

    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        String activityCanonicalName = activity.getClass().getCanonicalName();
        if (activityCanonicalName == null || !activityCanonicalName.equals(this.savedActivityName) || activity.getTaskId() == this.savedActivityTaskId) {
            this.timestampBackgroundStarted = -1L;
        }
    }

    public void onActivityStarted(@NonNull Activity activity) {
        if (this.timestampBackgroundStarted > -1L && PianoAnalyticsUtils.convertMillisTo(TimeUnit.SECONDS, Math.abs(PianoAnalyticsUtils.currentTimeMillis() - this.timestampBackgroundStarted)) >= Math.max(this.sessionBackgroundDuration, 2)) {
            this.newSessionInit();
            this.timestampBackgroundStarted = -1L;
        }
    }

    public void onActivityResumed(@NonNull Activity activity) {
    }

    public void onActivityPaused(@NonNull Activity activity) {
        this.savedActivityName = activity.getClass().getCanonicalName();
        this.savedActivityTaskId = activity.getTaskId();
        this.timestampBackgroundStarted = PianoAnalyticsUtils.currentTimeMillis();
    }

    public void onActivityStopped(@NonNull Activity activity) {
    }

    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
    }

    @Override
    public void processSetConfig(Model m) {
        Configuration configuration = m.getConfiguration();
        String sessionBackgroundDurationConfig = configuration.get(Configuration.ConfigurationKey.SESSION_BACKGROUND_DURATION);
        this.sessionBackgroundDuration = CastUtils.toInt(sessionBackgroundDurationConfig);
    }

    @Override
    public void processGetModel(Context ctx, Model m) {
        m.addContextProperties(this.getProperties());
    }

    @Override
    public boolean processTrackEvents(Context ctx, Model m, PianoAnalytics.OnWorkListener l) {
        m.addContextProperties(this.getProperties());
        return true;
    }

    private static interface ILifecycleFunction {
        public void computeMetric(SharedPreferences var1, SharedPreferences.Editor var2, PrivacyStep var3) throws ParseException;
    }
}

