/*
 * Decompiled with CFR 0.152.
 */
package io.piano.analytics;

import io.piano.analytics.CastUtils;
import io.piano.analytics.ListUtils;
import io.piano.analytics.PianoAnalyticsUtils;
import io.piano.analytics.SetUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class MapUtils {
    private static final String FLAT_SEPARATOR = "_";

    MapUtils() {
    }

    static Map<String, Object> fromJSONString(String s) {
        if (PianoAnalyticsUtils.isEmptyString(s)) {
            return new HashMap<String, Object>();
        }
        try {
            return MapUtils.fromJSONObject(new JSONObject(s));
        }
        catch (JSONException e) {
            return new HashMap<String, Object>();
        }
    }

    static <K, T> Map<K, Set<T>> mergeSets(Map<K, Set<T>> m1, Map<K, Set<T>> m2) {
        HashMap<K, Set<T>> result = new HashMap<K, Set<T>>();
        if (m1 != null) {
            result.putAll(m1);
        }
        if (m2 == null) {
            return result;
        }
        for (Map.Entry<K, Set<T>> entry : m2.entrySet()) {
            result.put(entry.getKey(), SetUtils.merge((Set)result.get(entry.getKey()), entry.getValue()));
        }
        return result;
    }

    static <K, T> void minimizeSet(Map<K, Set<T>> m, T element) {
        for (Map.Entry<K, Set<T>> entry : m.entrySet()) {
            m.put(entry.getKey(), SetUtils.getSingletonIfContains(entry.getValue(), element));
        }
    }

    static <K, V> V getValueOrPutDefault(Map<K, V> m, K key, V defaultValue) {
        if (!m.containsKey(key) || m.get(key) == null) {
            m.put(key, defaultValue);
        }
        return m.get(key);
    }

    static Map<String, Object> fromJSONObject(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = ListUtils.fromJSONArray((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = MapUtils.fromJSONObject((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    static Map<String, Object> toFlatten(Map<String, Object> src) {
        HashMap<String, Object> dst = new HashMap<String, Object>();
        if (src != null) {
            MapUtils.doFlatten(src, "", dst);
        }
        return dst;
    }

    private static void doFlatten(Map<String, Object> src, String prefix, Map<String, Object> dst) {
        for (Map.Entry<String, Object> e : src.entrySet()) {
            String completeKey;
            Object value = e.getValue();
            String string = completeKey = PianoAnalyticsUtils.isEmptyString(prefix) ? e.getKey() : prefix + FLAT_SEPARATOR + e.getKey();
            if (value instanceof Map) {
                MapUtils.doFlatten(CastUtils.toMap(String.class, Object.class, (Map)value), completeKey, dst);
                continue;
            }
            dst.put(completeKey.toLowerCase(Locale.getDefault()), value);
        }
    }

    static <K, V> Map<K, V> copy(Map<K, V> m) {
        if (m == null) {
            return null;
        }
        HashMap<K, V> cpy = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            cpy.put(entry.getKey(), entry.getValue());
        }
        return cpy;
    }

    static <V> V getFirstValue(Map<String, V> m, String ... keys) {
        for (String key : keys) {
            if (!m.containsKey(key)) continue;
            return m.get(key);
        }
        return null;
    }
}

